/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import java.io.Writer;

final class StringBufferWriter
extends Writer {
    private final StringBuffer buf;

    StringBufferWriter(int initialSize) {
        this.buf = new StringBuffer(initialSize);
    }

    StringBufferWriter(StringBuffer buffer, int initialSize) {
        this.buf = buffer;
        buffer.ensureCapacity(initialSize);
    }

    public void write(int c) {
        this.buf.append((char)c);
    }

    public void write(char[] characters, int off, int len) {
        if (len == 0) {
            return;
        }
        this.buf.append(characters, off, len);
    }

    public void write(char[] characters) {
        this.buf.append(characters);
    }

    public void write(String str) {
        this.buf.append(str);
    }

    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        return this.buf.toString();
    }
}

