/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.SingleIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class MultiIterator
implements Iterator {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Empty iterator has no next element");
        }

        public void remove() {
            throw new UnsupportedOperationException("Empty iterator does not support remove.");
        }
    };
    private final ArrayList iterators = new ArrayList();
    private Iterator listIterator;
    private Iterator currIterator = EMPTY_ITERATOR;
    private boolean hasNextWasCalled;

    public void addIterator(Collection collection) {
        this.iterators.add(collection.iterator());
    }

    public void addIterator(Iterator iter) {
        this.iterators.add(iter);
    }

    public void addIterator(CIMItemList list) {
        this.iterators.add(list.iterator());
    }

    public void addIterator(CIMUniqueList list) {
        this.iterators.add(list.iterator());
    }

    public void addObject(Object obj) {
        this.iterators.add(new SingleIterator(obj));
    }

    public boolean hasNext() {
        this.hasNextWasCalled = true;
        if (this.listIterator == null) {
            this.listIterator = ((AbstractList)this.iterators).iterator();
        }
        if (this.currIterator.hasNext()) {
            return true;
        }
        if (this.listIterator.hasNext()) {
            this.currIterator = (Iterator)this.listIterator.next();
            return this.hasNext();
        }
        this.currIterator = EMPTY_ITERATOR;
        return this.currIterator.hasNext();
    }

    public Object next() {
        if (!this.hasNextWasCalled) {
            this.hasNext();
        }
        this.hasNextWasCalled = false;
        return this.currIterator.next();
    }

    public void remove() {
        if (!this.hasNextWasCalled) {
            this.hasNext();
        }
        this.hasNextWasCalled = false;
        this.currIterator.remove();
    }
}

