/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClasspath;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancepath;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMLocalclasspath;
import com.sap.lcr.api.cim.CIMLocalinstancepath;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMWithNamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;

public class CIMValueReference
extends CIMItem
implements ICIMWithNamespacepath {
    public static final String DTD_NAME = "VALUE.REFERENCE";
    private ICIMItem xmlAppender;
    private CIMClasspath classpath;
    private CIMLocalclasspath localclasspath;
    private CIMClassname classname;
    private CIMInstancepath instancepath;
    private CIMLocalinstancepath localinstancepath;
    private CIMInstancename instancename;

    protected CIMValueReference() {
    }

    protected CIMValueReference(CIMClasspath aClasspath) {
        this.checkNonNull(aClasspath, "CLASSPATH");
        this.classpath = aClasspath;
        this.xmlAppender = this.classpath;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueReference(CIMLocalclasspath aLocalclasspath) {
        this.checkNonNull(aLocalclasspath, "LOCALCLASSPATH");
        this.localclasspath = aLocalclasspath;
        this.xmlAppender = this.localclasspath;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueReference(CIMClassname aClassname) {
        this.checkNonNull(aClassname, "CLASSNAME");
        this.classname = aClassname;
        this.xmlAppender = this.classname;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueReference(CIMInstancepath anInstancepath) {
        this.checkNonNull(anInstancepath, "INSTANCEPATH");
        this.instancepath = anInstancepath;
        this.xmlAppender = this.instancepath;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueReference(CIMLocalinstancepath aLocalinstancepath) {
        this.checkNonNull(aLocalinstancepath, "LOCALINSTANCEPATH");
        this.localinstancepath = aLocalinstancepath;
        this.xmlAppender = this.localinstancepath;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMValueReference(CIMInstancename anInstancename) {
        this.checkNonNull(anInstancename, "INSTANCENAME");
        this.instancename = anInstancename;
        this.xmlAppender = this.instancename;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void reinit() {
        this.checkWritable();
        this.xmlAppender = null;
        this.classpath = null;
        this.localclasspath = null;
        this.classname = null;
        this.instancepath = null;
        this.localinstancepath = null;
        this.instancename = null;
    }

    public CIMValueReference toWritable() {
        return (CIMValueReference)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        this.xmlAppender.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.xmlAppender != null;
    }

    public Object clone() {
        CIMValueReference clone = (CIMValueReference)super.clone();
        if (this.xmlAppender != null) {
            if (this.instancename != null) {
                clone.instancename = (CIMInstancename)this.instancename.clone();
                clone.xmlAppender = clone.instancename;
            } else if (this.classname != null) {
                clone.classname = (CIMClassname)this.classname.clone();
                clone.xmlAppender = clone.classname;
            } else if (this.localinstancepath != null) {
                clone.localinstancepath = (CIMLocalinstancepath)this.localinstancepath.clone();
                clone.xmlAppender = clone.localinstancepath;
            } else if (this.localclasspath != null) {
                clone.localclasspath = (CIMLocalclasspath)this.localclasspath.clone();
                clone.xmlAppender = clone.localclasspath;
            } else if (this.instancepath != null) {
                clone.instancepath = (CIMInstancepath)this.instancepath.clone();
                clone.xmlAppender = clone.instancepath;
            } else {
                clone.classpath = (CIMClasspath)this.classpath.clone();
                clone.xmlAppender = clone.classpath;
            }
        }
        return clone;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMValueReference) {
            CIMValueReference other = (CIMValueReference)aObj;
            return Util.equals(this.xmlAppender, other.xmlAppender);
        }
        return false;
    }

    public boolean equals(String aValRefString) {
        if (aValRefString == null) {
            return false;
        }
        try {
            return this.equals(CIMFactory.createObjPathFromString(aValRefString).createValueReference());
        }
        catch (LcrException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setClasspath(CIMClasspath aClasspath) {
        this.checkNonNull(aClasspath, "CLASSPATH");
        this.reinit();
        this.classpath = aClasspath.toWritable();
        this.xmlAppender = this.classpath;
    }

    public void setLocalclasspath(CIMLocalclasspath aLocalclasspath) {
        this.checkNonNull(aLocalclasspath, "LOCALCLASSPATH");
        this.reinit();
        this.localclasspath = aLocalclasspath.toWritable();
        this.xmlAppender = this.localclasspath;
    }

    public void setClassname(CIMClassname aClassname) {
        this.checkNonNull(aClassname, "CLASSNAME");
        this.reinit();
        this.classname = aClassname.toWritable();
        this.xmlAppender = this.classname;
    }

    public void setInstancepath(CIMInstancepath anInstancepath) {
        this.checkNonNull(anInstancepath, "INSTANCEPATH");
        this.reinit();
        this.instancepath = anInstancepath.toWritable();
        this.xmlAppender = this.instancepath;
    }

    public void setLocalinstancepath(CIMLocalinstancepath aLocalinstancepath) {
        this.checkNonNull(aLocalinstancepath, "LOCALINSTANCEPATH");
        this.reinit();
        this.localinstancepath = aLocalinstancepath.toWritable();
        this.xmlAppender = this.localinstancepath;
    }

    public void setInstancename(CIMInstancename anInstancename) {
        this.checkNonNull(anInstancename, "INSTANCENAME");
        this.reinit();
        this.instancename = anInstancename.toWritable();
        this.xmlAppender = this.instancename;
    }

    void addClasspath(CIMClasspath aClasspath) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClasspath, this.xmlAppender);
        }
        this.setClasspath(aClasspath);
    }

    void addLocalclasspath(CIMLocalclasspath aLocalclasspath) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aLocalclasspath, this.xmlAppender);
        }
        this.setLocalclasspath(aLocalclasspath);
    }

    void addClassname(CIMClassname aClassname) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aClassname, this.xmlAppender);
        }
        this.setClassname(aClassname);
    }

    void addInstancepath(CIMInstancepath anInstancepath) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstancepath, this.xmlAppender);
        }
        this.setInstancepath(anInstancepath);
    }

    void addLocalinstancepath(CIMLocalinstancepath aLocalinstancepath) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aLocalinstancepath, this.xmlAppender);
        }
        this.setLocalinstancepath(aLocalinstancepath);
    }

    void addInstancename(CIMInstancename anInstancename) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, anInstancename, this.xmlAppender);
        }
        this.setInstancename(anInstancename);
    }

    public CIMClassname getCIMClassname() {
        if (this.classpath != null) {
            return this.classpath.getCIMClassname();
        }
        if (this.localclasspath != null) {
            return this.localclasspath.getCIMClassname();
        }
        return this.classname;
    }

    public CIMLocalclasspath getLocalclasspath() {
        return this.localclasspath;
    }

    public CIMClasspath getClasspath() {
        return this.classpath;
    }

    public CIMInstancename getInstancename() {
        if (this.instancepath != null) {
            return this.instancepath.getInstancename();
        }
        if (this.localinstancepath != null) {
            return this.localinstancepath.getInstancename();
        }
        return this.instancename;
    }

    public CIMLocalinstancepath getLocalinstancepath() {
        return this.localinstancepath;
    }

    public CIMInstancepath getInstancepath() {
        return this.instancepath;
    }

    public CIMObjectReference toCIMObjectReference() throws ReferenceConversionExcp {
        if (this.instancepath != null) {
            return this.instancepath.toCIMObjectReference();
        }
        if (this.localinstancepath != null) {
            return this.localinstancepath.toCIMObjectReference();
        }
        if (this.instancename != null) {
            return this.instancename.toCIMObjectReference();
        }
        if (this.classpath != null) {
            return this.classpath.toCIMObjectReference();
        }
        if (this.localclasspath != null) {
            return this.localclasspath.toCIMObjectReference();
        }
        if (this.classname != null) {
            return this.classname.toCIMObjectReference();
        }
        throw new ReferenceConversionExcp(1);
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean comparable) {
        if (this.instancepath != null) {
            return this.instancepath.toString(comparable);
        }
        if (this.localinstancepath != null) {
            return this.localinstancepath.toString(comparable);
        }
        if (this.instancename != null) {
            return this.instancename.toString(comparable);
        }
        if (this.classpath != null) {
            return this.classpath.toString(comparable);
        }
        if (this.localclasspath != null) {
            return this.localclasspath.toString(comparable);
        }
        if (this.classname != null) {
            return this.classname.toString(comparable);
        }
        return "";
    }

    void addToCIMObjectReference(CIMObjectReference reference) throws ReferenceConversionExcp {
        reference.addCIMKey("", this.toCIMObjectReference());
    }

    public static CIMValueReference fromCIMObjectReference(CIMObjectReference reference) throws ReferenceConversionExcp {
        try {
            return reference.toCIMValueReference();
        }
        catch (LcrException e) {
            throw new ReferenceConversionExcp(e);
        }
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addValueReference(this);
    }

    public CIMHost getHost() {
        CIMNamespacepath nsp = this.getNamespacepath();
        return nsp == null ? null : nsp.getHost();
    }

    public String getHostname() {
        CIMHost host = this.getHost();
        return host == null ? "" : host.toString();
    }

    public CIMNamespacepath getNamespacepath() {
        if (this.classpath != null) {
            return this.classpath.getNamespacepath();
        }
        if (this.instancepath != null) {
            return this.instancepath.getNamespacepath();
        }
        return null;
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        if (this.localclasspath != null) {
            return this.localclasspath.getLocalnamespacepath();
        }
        if (this.localinstancepath != null) {
            return this.localinstancepath.getLocalnamespacepath();
        }
        if (this.classpath != null) {
            return this.classpath.getLocalnamespacepath();
        }
        if (this.instancepath != null) {
            return this.instancepath.getLocalnamespacepath();
        }
        return null;
    }
}

