/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueList;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class CIMValueArray
extends CIMItem {
    public static final String DTD_NAME = "VALUE.ARRAY";
    private static final Comparator BigIntegerRangeLowerBoundComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            BigInteger one = ((BigInteger[])o1)[0];
            BigInteger two = ((BigInteger[])o2)[0];
            return one.compareTo(two);
        }
    };
    private CIMValueList valueList = CIMFactory.valueList();

    protected CIMValueArray() {
    }

    protected CIMValueArray(String[] aStringArray) {
        this();
        this.valueList.addAll(aStringArray);
    }

    public CIMValueArray toWritable() {
        return (CIMValueArray)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            this.valueList.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        this.valueList.makeReadOnly();
    }

    boolean isDTDConformant() {
        return true;
    }

    public Object clone() {
        CIMValueArray clone = (CIMValueArray)super.clone();
        clone.valueList = (CIMValueList)this.valueList.clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMValueArray) {
            CIMValueList otherList = ((CIMValueArray)obj).valueList;
            int size = this.valueList.size();
            if (size != otherList.size()) {
                return false;
            }
            int i = 0;
            while (i < size) {
                CIMValue thisValue = this.valueList.get(i);
                if (!otherList.contains(thisValue)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void addValue(CIMValue aCIMValue) {
        this.valueList.add(aCIMValue);
    }

    public boolean isEmpty() {
        return this.valueList.size() == 0;
    }

    public boolean containsValue(String value) {
        return this.valueList.contains(value);
    }

    public boolean containsValue(String value, String type) {
        if (!type.startsWith("uint") && !type.startsWith("sint")) {
            return this.containsValue(value);
        }
        try {
            BigInteger bigIntValue = CIMUtil.toBigInt(value);
            int thisSize = this.valueList.size();
            int j = 0;
            while (j < thisSize) {
                String listedValue = this.valueList.get(j).toString();
                if (listedValue.equals(value)) {
                    return true;
                }
                BigInteger[] bounds = CIMUtil.toBigIntRange(listedValue, type);
                if (bigIntValue.compareTo(bounds[0]) >= 0 && bigIntValue.compareTo(bounds[1]) <= 0) {
                    return true;
                }
                ++j;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public boolean containsAll(CIMValueArray other) {
        int otherSize = other.size();
        int i = 0;
        while (i < otherSize) {
            String otherValue = other.get(i).getStringvalue();
            if (this.containsValue(otherValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAll(CIMValueArray other, String type) {
        if (!type.startsWith("uint") && !type.startsWith("sint")) {
            return this.containsAll(other);
        }
        ArrayList otherRanges = this.generateRanges(other.valueList, type);
        if (otherRanges == null) {
            return false;
        }
        ArrayList thisRanges = this.generateRanges(this.valueList, type);
        if (thisRanges == null) {
            return false;
        }
        int otherSize = otherRanges.size();
        int i = 0;
        while (i < otherSize) {
            if (!this.rangeListContainsRange(thisRanges, (BigInteger[])otherRanges.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ArrayList generateRanges(CIMValueList aValueList, String type) {
        try {
            int size = aValueList.size();
            ArrayList<BigInteger[]> result = new ArrayList<BigInteger[]>(size);
            int i = 0;
            while (i < size) {
                String value = aValueList.get(i).toString();
                result.add(CIMUtil.toBigIntRange(value, type));
                ++i;
            }
            Collections.sort(result, BigIntegerRangeLowerBoundComparator);
            int i2 = result.size() - 1;
            while (i2 > 0) {
                BigInteger[] thisRange = (BigInteger[])result.get(i2);
                BigInteger[] prevRange = (BigInteger[])result.get(i2 - 1);
                BigInteger thisLower = thisRange[0].subtract(BigInteger.ONE);
                BigInteger thisUpper = thisRange[1];
                BigInteger prevUpper = prevRange[1];
                if (thisLower.compareTo(prevUpper) <= 0 && prevUpper.compareTo(thisUpper) < 0) {
                    prevRange[1] = thisUpper;
                    result.remove(i2);
                }
                --i2;
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private boolean rangeListContainsRange(ArrayList rangeList, BigInteger[] range) {
        int size = rangeList.size();
        int i = 0;
        while (i < size) {
            BigInteger[] nextRange = (BigInteger[])rangeList.get(i);
            if (nextRange[0].compareTo(range[0]) <= 0 && nextRange[1].compareTo(range[1]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addTo(Collection collection) {
        this.valueList.addItemsTo(collection);
    }

    public int size() {
        return this.valueList.size();
    }

    public CIMValue get(int idx) {
        return this.valueList.get(idx);
    }

    public void set(int idx, CIMValue value) {
        this.valueList.set(idx, value);
    }

    public void set(int idx, String value) {
        this.set(idx, CIMFactory.value(value));
    }

    public void remove(int idx) {
        this.valueList.remove(idx);
    }

    public Iterator iterator() {
        return this.valueList.iterator();
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        if (this.isEmpty()) {
            this.appendXml(writer, DTD_NAME, indent);
        } else {
            this.appendXml(writer, DTD_NAME, this.valueList.iterator(), indent);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMValueArray)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMValueArray source = (CIMValueArray)sourceItem;
        int i = 0;
        while (i < source.valueList.size()) {
            CIMValue sourceValue = source.valueList.get(i);
            if (!this.containsValue(sourceValue.getStringvalue())) {
                this.addValue((CIMValue)sourceValue.clone());
            }
            ++i;
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addValueArray(this);
    }
}

