/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMMethod;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMXmlAppender;
import com.sap.lcr.api.cim.CIMXmlAppenderReadOnly;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ICIMProperties;
import com.sap.lcr.api.cim.ICIMReadOnly;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReadOnlyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class CIMUniqueList
extends CIMXmlAppenderReadOnly {
    private ArrayList list;
    private final boolean sort;

    CIMUniqueList() {
        this(false);
    }

    CIMUniqueList(boolean sorted) {
        super(false);
        this.list = new ArrayList();
        this.sort = sorted;
    }

    CIMUniqueList(int initialCapacity) {
        this(initialCapacity, false);
    }

    CIMUniqueList(int initialCapacity, boolean sorted) {
        super(false);
        this.list = new ArrayList(initialCapacity);
        this.sort = sorted;
    }

    CIMUniqueList(ICIMNamedElement element) {
        this();
        this.list.add(element);
        if (element.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    final void makeSubelementsReadOnly() {
        int i = 0;
        while (i < this.list.size()) {
            ICIMReadOnly element = (ICIMReadOnly)this.list.get(i);
            element.makeReadOnly();
            ++i;
        }
    }

    final void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        int i = 0;
        while (i < this.list.size()) {
            ICIMNamedElement element = (ICIMNamedElement)this.list.get(i);
            element.validateCharacters(includeNames);
            ++i;
        }
    }

    final void add(ICIMNamedElement element) {
        this.checkWritable();
        element = (ICIMNamedElement)element.getWritable();
        String elemName = element.getName();
        int idx = this.indexOf(elemName);
        if (idx == -1) {
            if (this.sort) {
                this.insertSorted(element);
            } else {
                this.list.add(element);
            }
        } else {
            this.list.set(idx, element);
        }
    }

    final void addAll(CIMUniqueList aList) {
        this.checkWritable();
        int i = 0;
        while (i < aList.size()) {
            this.add(aList.getItem(i));
            ++i;
        }
    }

    final boolean equalsImpl(CIMUniqueList other, boolean namesOnly) {
        if (this == other) {
            return true;
        }
        int size = this.list.size();
        if (size != other.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            ICIMNamedElement thisElem = (ICIMNamedElement)this.list.get(i);
            ICIMNamedElement otherElem = other.getItem(thisElem.getName());
            if (otherElem == null) {
                return false;
            }
            if (!namesOnly && !otherElem.equals(thisElem)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void insertSorted(ICIMNamedElement element) {
        String elementNameLower = element.getName().toLowerCase();
        int size = this.list.size();
        int i = 0;
        while (i < size) {
            String iNameLower = ((ICIMNamedElement)this.list.get(i)).getName().toLowerCase();
            if (elementNameLower.compareTo(iNameLower) < 0) break;
            ++i;
        }
        this.list.add(i, element);
    }

    public Object clone() {
        CIMUniqueList clone = (CIMUniqueList)super.clone();
        clone.list = CIMUtil.cloneCIMItems(this.list);
        return clone;
    }

    public Object cloneShallow() {
        CIMUniqueList clone = (CIMUniqueList)super.clone();
        clone.list = (ArrayList)this.list.clone();
        if (this.isReadOnly()) {
            clone.makeReadOnly();
        }
        return clone;
    }

    final Object cloneIncludeQualifiers(boolean includeQualifiers) {
        CIMUniqueList clone = (CIMUniqueList)super.clone();
        int size = this.list.size();
        clone.list = new ArrayList(size);
        int i = 0;
        while (i < size) {
            CIMItemWAWQ item = (CIMItemWAWQ)this.list.get(i);
            clone.list.add(item.clone(includeQualifiers));
            ++i;
        }
        return clone;
    }

    final Object cloneMethods(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) {
        CIMUniqueList clone = (CIMUniqueList)super.clone();
        int size = this.list.size();
        clone.list = new ArrayList(size);
        int i = 0;
        while (i < size) {
            CIMMethod method = (CIMMethod)this.list.get(i);
            if (!localOnly || !method.isPropagated()) {
                CIMMethod clonedMethod = (CIMMethod)method.clone(includeQualifiers);
                if (!includeClassOrigin) {
                    clonedMethod.setClassOrigin(null);
                }
                clone.list.add(clonedMethod);
            }
            ++i;
        }
        return clone;
    }

    final Object cloneProperties(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propsIncluded, CanonicalizedStrings propsExcluded) {
        CIMUniqueList clone = (CIMUniqueList)super.clone();
        int size = this.list.size();
        clone.list = new ArrayList(size);
        int i = 0;
        while (i < size) {
            ICIMProperties prop = (ICIMProperties)this.list.get(i);
            if (!localOnly || !prop.isPropagated()) {
                String name = prop.getName();
                if (!(propsExcluded != null && propsExcluded.contains(name) || propsIncluded != null && !propsIncluded.contains(name))) {
                    ICIMProperties clonedProp = (ICIMProperties)prop.clone(includeQualifiers);
                    if (!includeClassOrigin) {
                        clonedProp.setClassOrigin(null);
                    }
                    clone.list.add(clonedProp);
                }
            }
            ++i;
        }
        return clone;
    }

    public final void addTo(Collection collection) {
        collection.addAll(this.list);
    }

    public final void clear() {
        this.checkWritable();
        this.list.clear();
    }

    public final boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public final void ensureCapacity(int capacity) {
        this.list.ensureCapacity(capacity);
    }

    public final ICIMNamedElement getItem(String name) {
        int idx = this.indexOf(name);
        return idx != -1 ? (ICIMNamedElement)this.list.get(idx) : null;
    }

    public final ICIMNamedElement getItem(int idx) {
        return (ICIMNamedElement)this.list.get(idx);
    }

    public final ICIMNamedElement removeItem(int idx) {
        this.checkWritable();
        return (ICIMNamedElement)this.list.remove(idx);
    }

    public final ICIMNamedElement removeItem(String name) {
        this.checkWritable();
        int idx = this.indexOf(name);
        return idx != -1 ? (ICIMNamedElement)this.list.remove(idx) : null;
    }

    public final int indexOf(String name) {
        if (name == null) {
            return -1;
        }
        int size = this.list.size();
        int i = 0;
        while (i < size) {
            ICIMNamedElement item = (ICIMNamedElement)this.list.get(i);
            if (name.equalsIgnoreCase(item.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final Iterator iterator() {
        return new ReadOnlyIterator(((AbstractList)this.list).iterator(), this);
    }

    public final int size() {
        return this.list.size();
    }

    public final Object[] toArray(Object[] array) {
        return this.list.toArray(array);
    }

    public final void sort() {
        if (this.sort) {
            return;
        }
        Collections.sort(this.list, CIMUtil.CIM_NAME_COMPARATOR);
    }

    public final void appendXml(Writer writer, String indent) throws IOException {
        Iterator iter = ((AbstractList)this.list).iterator();
        while (iter.hasNext()) {
            CIMXmlAppender nextAppender = (CIMXmlAppender)iter.next();
            nextAppender.appendXml(writer, indent);
        }
    }
}

