/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueRefarray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;

public class CIMReturnValue
extends CIMItem {
    public static final String DTD_NAME = "RETURNVALUE";
    private CIMValue value;
    private CIMValueArray valueArray;
    private CIMValueReference valueReference;
    private CIMValueRefarray valueRefarray;
    private ICIMItem xmlAppender;

    protected CIMReturnValue() {
    }

    protected CIMReturnValue(CIMValue aCIMValue) {
        this.checkNonNull(aCIMValue, "VALUE");
        this.value = aCIMValue;
        this.xmlAppender = this.value;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMReturnValue(CIMValueArray aCIMValueArray) {
        this.checkNonNull(aCIMValueArray, "VALUE.ARRAY");
        this.valueArray = aCIMValueArray;
        this.xmlAppender = this.valueArray;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMReturnValue(CIMValueReference aCIMValueReference) {
        this.checkNonNull(aCIMValueReference, "VALUE.REFERENCE");
        this.valueReference = aCIMValueReference;
        this.xmlAppender = this.valueReference;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMReturnValue(CIMValueRefarray aCIMValueRefarray) {
        this.checkNonNull(aCIMValueRefarray, "VALUE.REFARRAY");
        this.valueRefarray = aCIMValueRefarray;
        this.xmlAppender = this.valueRefarray;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void reinit() {
        this.checkWritable();
        this.value = null;
        this.valueReference = null;
        this.valueArray = null;
        this.valueRefarray = null;
        this.xmlAppender = null;
    }

    public CIMReturnValue toWritable() {
        return (CIMReturnValue)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.xmlAppender != null;
    }

    public Object clone() {
        CIMReturnValue clone = (CIMReturnValue)super.clone();
        if (this.value != null) {
            clone.value = (CIMValue)this.value.clone();
            clone.xmlAppender = clone.value;
        } else if (this.valueArray != null) {
            clone.valueArray = (CIMValueArray)this.valueArray.clone();
            clone.xmlAppender = clone.valueArray;
        } else if (this.valueReference != null) {
            clone.valueReference = (CIMValueReference)this.valueReference.clone();
            clone.xmlAppender = clone.valueReference;
        } else if (this.valueRefarray != null) {
            clone.valueRefarray = (CIMValueRefarray)this.valueRefarray.clone();
            clone.xmlAppender = clone.valueRefarray;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setValue(CIMValue aValue) {
        this.checkNonNull(aValue, "VALUE");
        this.reinit();
        this.value = aValue.toWritable();
        this.xmlAppender = this.value;
    }

    public void setValueArray(CIMValueArray aValueArray) {
        this.checkNonNull(aValueArray, "VALUE.ARRAY");
        this.reinit();
        this.valueArray = aValueArray.toWritable();
        this.xmlAppender = this.valueArray;
    }

    public void setValueReference(CIMValueReference aValueReference) {
        this.checkNonNull(aValueReference, "VALUE.REFERENCE");
        this.reinit();
        this.valueReference = aValueReference.toWritable();
        this.xmlAppender = this.valueReference;
    }

    public void setValueRefarray(CIMValueRefarray aValueRefarray) {
        this.checkNonNull(aValueRefarray, "VALUE.REFARRAY");
        this.reinit();
        this.valueRefarray = aValueRefarray.toWritable();
        this.xmlAppender = this.valueRefarray;
    }

    void addValue(CIMValue aValue) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValue, this.xmlAppender);
        }
        this.setValue(aValue);
    }

    void addValueArray(CIMValueArray aValueArray) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueArray, this.xmlAppender);
        }
        this.setValueArray(aValueArray);
    }

    void addValueReference(CIMValueReference aValueReference) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueReference, this.xmlAppender);
        }
        this.setValueReference(aValueReference);
    }

    void addValueRefarray(CIMValueRefarray aValueRefarray) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueRefarray, this.xmlAppender);
        }
        this.setValueRefarray(aValueRefarray);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addReturnValue(this);
    }
}

