/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.xml.sax.Attributes;

public class CIMQualifier
extends CIMItemWA
implements ICIMNamedElement {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMQualifier == null ? (class$com$sap$lcr$api$cim$CIMQualifier = CIMQualifier.class$("com.sap.lcr.api.cim.CIMQualifier")) : class$com$sap$lcr$api$cim$CIMQualifier).getName());
    public static final String DTD_NAME = "QUALIFIER";
    private String attrName;
    private String attrType;
    private boolean attrPropagated;
    private boolean attrOverridable = true;
    private boolean attrToSubclass = true;
    private boolean attrToInstance;
    private boolean attrTranslatable;
    private CIMValue value;
    private CIMValueArray valueArray;
    private ICIMItem xmlAppender;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMQualifier;

    protected CIMQualifier() {
    }

    protected CIMQualifier(String aCIMName, String aCIMType) throws ItemConstructionExcp {
        this.checkNonNull(aCIMName, "NAME");
        this.checkNonNull(aCIMType, "TYPE");
        CIMUtil.checkCIMType(aCIMType);
        this.attrName = aCIMName;
        this.attrType = aCIMType;
    }

    protected CIMQualifier(String aCIMName, String aCIMType, CIMValue aValue) throws ItemConstructionExcp {
        this(aCIMName, aCIMType);
        this.value = aValue;
        this.xmlAppender = this.value;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMQualifier(String aCIMName, String aCIMType, CIMValueArray aValueArray) throws ItemConstructionExcp {
        this(aCIMName, aCIMType);
        this.valueArray = aValueArray;
        this.xmlAppender = this.valueArray;
        if (this.xmlAppender != null && this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMQualifier(String name, String type, String value) throws ItemConstructionExcp {
        this(name, type, value == null ? null : CIMFactory.value(value));
    }

    protected CIMQualifier(String name, boolean boolValue) {
        this();
        this.attrName = name;
        this.attrType = "boolean";
        this.value = CIMFactory.value(boolValue);
        this.xmlAppender = this.value;
    }

    protected CIMQualifier(String name, Date date) {
        this();
        this.attrName = name;
        this.attrType = "datetime";
        if (date != null) {
            this.value = CIMFactory.value(CIMUtil.date2CimDateTime(date));
            this.xmlAppender = this.value;
        }
    }

    public CIMQualifier toWritable() {
        return (CIMQualifier)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null && this.attrType != null;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public Object clone() {
        CIMQualifier clone = (CIMQualifier)super.clone();
        if (this.value != null) {
            clone.value = (CIMValue)this.value.clone();
            clone.xmlAppender = clone.value;
        } else if (this.valueArray != null) {
            clone.valueArray = (CIMValueArray)this.valueArray.clone();
            clone.xmlAppender = clone.valueArray;
        }
        return clone;
    }

    public boolean equals(Object obj) {
        CIMQualifier other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMQualifier && this.equalsDefinition(other = (CIMQualifier)obj)) {
            return this.attrPropagated == other.attrPropagated;
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public boolean equalsDefinition(CIMQualifier other) {
        if (this == other) {
            return true;
        }
        try {
            if (!this.attrName.equalsIgnoreCase(other.attrName) || !this.attrType.equals(other.attrType) || this.attrOverridable != other.attrOverridable || this.attrToInstance != other.attrToInstance || this.attrToSubclass != other.attrToSubclass || this.attrTranslatable != other.attrTranslatable) {
                return false;
            }
            if ("boolean".equals(this.attrType)) {
                return CIMUtil.equalsBoolean(this.value, other.value) && CIMUtil.equalsBoolean(this.valueArray, other.valueArray);
            }
            return Util.equals(this.value, other.value) && Util.equals(this.valueArray, other.valueArray);
        }
        catch (NullPointerException npe) {
            if (CIMTraceUtil.traceLevel >= 3) {
                logger.debug("Invalid CIMQualifier", npe);
            }
            return false;
        }
    }

    public void setValue(CIMValue aValue) {
        this.checkWritable();
        this.value = aValue == null ? null : aValue.toWritable();
        this.xmlAppender = this.value;
        this.valueArray = null;
    }

    public void setValue(String value) {
        this.setValue(CIMFactory.value(value));
    }

    public void setValue(int value) {
        this.setValue(CIMFactory.value(value));
    }

    public void setValue(boolean value) {
        this.setValue(CIMFactory.value(value));
    }

    public void setValueArray(CIMValueArray aValueArray) {
        this.checkWritable();
        this.value = null;
        this.valueArray = aValueArray == null ? null : aValueArray;
        this.xmlAppender = this.valueArray;
    }

    public String getName() {
        return this.attrName;
    }

    public void setName(String name) {
        this.checkWritable();
        this.attrName = name;
    }

    public String getType() {
        return this.attrType;
    }

    public String getValue() {
        return this.value != null ? this.value.getStringvalue() : null;
    }

    public CIMValue getCIMValue() {
        return this.value;
    }

    public CIMValueArray getValueArray() {
        return this.valueArray;
    }

    public boolean isPropagated() {
        return this.attrPropagated;
    }

    public boolean isOverridable() {
        return this.attrOverridable;
    }

    public boolean isToSubclass() {
        return this.attrToSubclass;
    }

    public boolean isToInstance() {
        return this.attrToInstance;
    }

    public boolean isTranslatable() {
        return this.attrTranslatable;
    }

    public void setPropagated(boolean aBoolean) {
        this.checkWritable();
        this.attrPropagated = aBoolean;
    }

    public void setFlavors(boolean overridable, boolean toSubclass, boolean toInstance, boolean translatable) {
        this.checkWritable();
        this.attrOverridable = overridable;
        this.attrToSubclass = toSubclass;
        this.attrToInstance = toInstance;
        this.attrTranslatable = translatable;
    }

    public void setOverridable(boolean aBoolean) {
        this.checkWritable();
        this.attrOverridable = aBoolean;
    }

    public void setToSubclass(boolean aBoolean) {
        this.checkWritable();
        this.attrToSubclass = aBoolean;
    }

    public void setToInstance(boolean aBoolean) {
        this.checkWritable();
        this.attrToInstance = aBoolean;
    }

    public void setTranslatable(boolean aBoolean) {
        this.checkWritable();
        this.attrTranslatable = aBoolean;
    }

    public Date toDate() throws LcrException {
        if (!"datetime".equals(this.attrType)) {
            throw new LcrException("Qualifier " + this.attrName + " is not of type " + "datetime");
        }
        return this.value == null ? null : CIMUtil.cimDateTime2Date(this.value.getStringvalue());
    }

    public boolean toBoolean(boolean defaultValue) throws LcrException {
        if (!"boolean".equals(this.attrType)) {
            throw new LcrException("Qualifier " + this.attrName + " is not of type boolean");
        }
        String strValue = this.getValue();
        if (strValue == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("false".equals(strValue)) {
            return false;
        }
        throw new LcrException("Qualifier " + this.attrName + " is not a valid boolean: " + strValue);
    }

    public long toLong(long defaultValue) throws LcrException {
        if ("uint8".equals(this.attrType) || "uint16".equals(this.attrType) || "uint32".equals(this.attrType) || "uint64".equals(this.attrType) || "sint8".equals(this.attrType) || "sint16".equals(this.attrType) || "sint32".equals(this.attrType) || "sint64".equals(this.attrType)) {
            try {
                return this.value == null ? defaultValue : Long.parseLong(this.value.getStringvalue());
            }
            catch (NumberFormatException nfe) {
                throw new LcrException("Conversion to 'long' failed: " + this.value.getStringvalue());
            }
        }
        throw new LcrException("Qualifier " + this.attrName + " is not of any integer type");
    }

    public int toInt(int defaultValue) throws LcrException {
        if ("uint8".equals(this.attrType) || "uint16".equals(this.attrType) || "uint32".equals(this.attrType) || "uint64".equals(this.attrType) || "sint8".equals(this.attrType) || "sint16".equals(this.attrType) || "sint32".equals(this.attrType) || "sint64".equals(this.attrType)) {
            try {
                return this.value == null ? defaultValue : Integer.parseInt(this.value.getStringvalue());
            }
            catch (NumberFormatException nfe) {
                throw new LcrException("Conversion to 'int' failed: " + this.value.getStringvalue());
            }
        }
        throw new LcrException("Qualifier " + this.attrName + " is not of any integer type");
    }

    public double toDouble(double defaultValue) throws LcrException {
        if ("real32".equals(this.attrType) || "real64".equals(this.attrType)) {
            try {
                double result;
                double d = result = this.value == null ? defaultValue : Double.parseDouble(this.value.getStringvalue());
                if (Double.isInfinite(result)) {
                    throw new LcrException("Conversion to 'double' failed: " + this.value.getStringvalue());
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new LcrException("Conversion to 'double' failed: " + this.value.getStringvalue());
            }
        }
        throw new LcrException("Qualifier " + this.attrName + " is not of any integer type");
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        CIMUtil.appendXmlAttributeUnescaped(writer, "TYPE", this.attrType);
        if (!this.attrOverridable) {
            CIMUtil.appendXmlAttribute(writer, "OVERRIDABLE", this.attrOverridable);
        }
        if (!this.attrToSubclass) {
            CIMUtil.appendXmlAttribute(writer, "TOSUBCLASS", this.attrToSubclass);
        }
        if (this.attrToInstance) {
            CIMUtil.appendXmlAttribute(writer, "TOINSTANCE", this.attrToInstance);
        }
        if (this.attrTranslatable) {
            CIMUtil.appendXmlAttribute(writer, "TRANSLATABLE", this.attrTranslatable);
        }
        if (this.attrPropagated) {
            CIMUtil.appendXmlAttribute(writer, "PROPAGATED", this.attrPropagated);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMQualifier)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMQualifier source = (CIMQualifier)sourceItem;
        if (this.value == null) {
            if (this.valueArray != null) {
                this.valueArray.merge(source.valueArray);
            } else if (source.value != null) {
                this.addValue((CIMValue)source.value.clone());
            } else if (source.valueArray != null) {
                this.addValueArray((CIMValueArray)source.valueArray.clone());
            }
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("TYPE".equals(name)) {
                CIMUtil.checkCIMType(value);
                this.attrType = value;
            } else if ("PROPAGATED".equals(name)) {
                this.attrPropagated = CIMUtil.string2boolean(value);
            } else if ("OVERRIDABLE".equals(name)) {
                this.attrOverridable = CIMUtil.string2boolean(value);
            } else if ("TOSUBCLASS".equals(name)) {
                this.attrToSubclass = CIMUtil.string2boolean(value);
            } else if ("TOINSTANCE".equals(name)) {
                this.attrToInstance = CIMUtil.string2boolean(value);
            } else if ("TRANSLATABLE".equals(name)) {
                this.attrTranslatable = CIMUtil.string2boolean(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
        if (this.attrType == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("TYPE", this);
        }
    }

    void addValue(CIMValue aValue) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValue, this.xmlAppender);
        }
        this.setValue(aValue);
    }

    void addValueArray(CIMValueArray aValueArray) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueArray, this.xmlAppender);
        }
        this.setValueArray(aValueArray);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addQualifier(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

