/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMKeyProperties;
import com.sap.lcr.api.cim.ICIMProperties;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMPropertyReference
extends CIMItemWAWQ
implements ICIMProperties,
ICIMKeyProperties {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMPropertyReference == null ? (class$com$sap$lcr$api$cim$CIMPropertyReference = CIMPropertyReference.class$("com.sap.lcr.api.cim.CIMPropertyReference")) : class$com$sap$lcr$api$cim$CIMPropertyReference).getName());
    public static final String DTD_NAME = "PROPERTY.REFERENCE";
    private String attrName;
    private String attrClassOrigin;
    private String attrReferenceClass;
    private boolean attrPropagated;
    private CIMValueReference valueReference;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMPropertyReference;

    protected CIMPropertyReference() {
    }

    protected CIMPropertyReference(String aCIMName) {
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
    }

    protected CIMPropertyReference(String aCIMName, CIMValueReference aValueReference) {
        this(aCIMName);
        this.valueReference = aValueReference;
        if (this.valueReference != null && this.valueReference.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMPropertyReference toWritable() {
        return (CIMPropertyReference)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
                this.validateStringForXml(this.attrClassOrigin, "CLASSORIGIN");
                this.validateStringForXml(this.attrReferenceClass, "REFERENCECLASS");
            }
            if (this.valueReference != null) {
                this.valueReference.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnlyWOQualifiers() {
        if (this.valueReference != null) {
            this.valueReference.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public Object clone(boolean includeQualifiers) {
        CIMPropertyReference clone = (CIMPropertyReference)super.clone(includeQualifiers);
        if (this.valueReference != null) {
            clone.valueReference = (CIMValueReference)this.valueReference.clone();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMPropertyReference) {
                CIMPropertyReference other = (CIMPropertyReference)obj;
                try {
                    return this.attrName.equalsIgnoreCase(other.attrName) && Util.equals(this.valueReference, other.valueReference) && Util.equalsIgnoreCase(this.attrReferenceClass, other.attrReferenceClass) && Util.equalsIgnoreCase(this.attrClassOrigin, other.attrClassOrigin) && this.attrPropagated == other.attrPropagated && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMPropertyReference", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setValueReference(CIMValueReference aValueReference) {
        this.checkWritable();
        this.valueReference = aValueReference == null ? null : aValueReference.toWritable();
    }

    public CIMValueReference getValueReference() {
        return this.valueReference;
    }

    public void removeValueReference() {
        this.checkWritable();
        this.valueReference = null;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        subelements.addIterator(this.getQualifiers());
        if (this.valueReference != null) {
            subelements.addObject(this.valueReference);
        }
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        if (this.attrReferenceClass != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "REFERENCECLASS", this.attrReferenceClass);
        }
        if (this.attrClassOrigin != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "CLASSORIGIN", this.attrClassOrigin);
        }
        if (this.attrPropagated) {
            CIMUtil.appendXmlAttribute(writer, "PROPAGATED", this.attrPropagated);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMPropertyReference)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMPropertyReference source = (CIMPropertyReference)sourceItem;
        this.mergeQualifiersWritable(source);
        if (this.valueReference == null && source.valueReference != null) {
            this.addValueReference((CIMValueReference)source.valueReference.clone());
        }
    }

    public void setReferenceClass(String aReferenceClass) {
        this.checkWritable();
        this.attrReferenceClass = aReferenceClass;
    }

    public String getReferenceClass() {
        return this.attrReferenceClass;
    }

    public boolean isWeak() {
        return "true".equalsIgnoreCase(this.getQualifierValue("Weak"));
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("CLASSORIGIN".equals(name)) {
                this.attrClassOrigin = value;
            } else if ("REFERENCECLASS".equals(name)) {
                this.attrReferenceClass = value;
            } else if ("PROPAGATED".equals(name)) {
                this.attrPropagated = CIMUtil.string2boolean(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void addValueReference(CIMValueReference aValueReference) throws ItemConstructionExcp {
        if (this.valueReference != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aValueReference);
        }
        this.setValueReference(aValueReference);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addPropertyReference(this);
    }

    public String getName() {
        return this.attrName;
    }

    public void setName(String name) {
        this.checkWritable();
        this.attrName = name;
    }

    public String getClassOrigin() {
        return this.attrClassOrigin;
    }

    public void setClassOrigin(String aClassOrigin) {
        this.checkWritable();
        this.attrClassOrigin = aClassOrigin;
    }

    public boolean isPropagated() {
        return this.attrPropagated;
    }

    public void setPropagated(boolean aBoolean) {
        this.checkWritable();
        this.attrPropagated = aBoolean;
    }

    public boolean isRequired() {
        return true;
    }

    public boolean isKeyProperty() {
        String key = this.getQualifierValue("Key");
        return "true".equalsIgnoreCase(key);
    }

    public void declareAsKey() {
        this.checkWritable();
        this.addQualifier(CIMFactory.qualifier("Key", true));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

