/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMParameterRefarray
extends CIMItemWAWQ
implements ICIMNamedElement {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMParameterRefarray == null ? (class$com$sap$lcr$api$cim$CIMParameterRefarray = CIMParameterRefarray.class$("com.sap.lcr.api.cim.CIMParameterRefarray")) : class$com$sap$lcr$api$cim$CIMParameterRefarray).getName());
    public static final String DTD_NAME = "PARAMETER.REFARRAY";
    private String attrName;
    private String attrReferenceClass;
    private int attrArraySize;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMParameterRefarray;

    protected CIMParameterRefarray() {
    }

    protected CIMParameterRefarray(String aCIMName) {
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
    }

    public CIMParameterRefarray toWritable() {
        return (CIMParameterRefarray)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
                this.validateStringForXml(this.attrReferenceClass, "REFERENCECLASS");
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnlyWOQualifiers() {
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMParameterRefarray) {
                CIMParameterRefarray other = (CIMParameterRefarray)obj;
                try {
                    return this.attrName.equalsIgnoreCase(other.attrName) && Util.equalsIgnoreCase(this.attrReferenceClass, other.attrReferenceClass) && this.attrArraySize == other.attrArraySize && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMParameterRefarray", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    public String getReferenceClass() {
        return this.attrReferenceClass;
    }

    public void setReferenceClass(String aReferenceClass) {
        this.checkWritable();
        this.attrReferenceClass = aReferenceClass;
    }

    public int getArraySize() {
        return this.attrArraySize;
    }

    public void setArraySize(int arraySize) {
        this.checkWritable();
        this.attrArraySize = arraySize > 0 ? arraySize : 0;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.getQualifiers(), indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        if (this.attrReferenceClass != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "REFERENCECLASS", this.attrReferenceClass);
        }
        if (this.attrArraySize > 0) {
            CIMUtil.appendXmlAttribute(writer, "ARRAYSIZE", this.attrArraySize);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMParameterRefarray)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMParameterRefarray source = (CIMParameterRefarray)sourceItem;
        this.mergeQualifiersWritable(source);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("REFERENCECLASS".equals(name)) {
                this.attrReferenceClass = value;
            } else if ("ARRAYSIZE".equals(name)) {
                try {
                    this.setArraySize(CIMUtil.toInt(value));
                }
                catch (NumberFormatException nfe) {
                    throw ItemConstructionExcp.createInvalidIntegerAttributeExcp(value, "ARRAYSIZE", this);
                }
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addParameterRefarray(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

