/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMNamespace
extends CIMItemWA {
    public static final String DTD_NAME = "NAMESPACE";
    private String attrName = "";
    private String lowerName = "";

    protected CIMNamespace() {
    }

    protected CIMNamespace(String aNamespacename) {
        this.checkNonNull(aNamespacename, "Value");
        this.attrName = aNamespacename;
        this.lowerName = this.attrName.toLowerCase();
    }

    public CIMNamespace toWritable() {
        return (CIMNamespace)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMNamespace) {
            CIMNamespace other = (CIMNamespace)aObj;
            return Util.equals(this.lowerName, other.lowerName);
        }
        return false;
    }

    public boolean equals(String aNamespace) {
        return aNamespace == null ? false : aNamespace.equalsIgnoreCase(this.attrName);
    }

    public int hashCode() {
        return this.lowerName.hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String toDisplayString() {
        return this.attrName;
    }

    public String toString() {
        return this.lowerName;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            this.lowerName = this.attrName.toLowerCase();
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addNamespace(this);
    }
}

