/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMSimpleRsp;
import com.sap.lcr.api.cim.CIMSimpleRspList;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;

public class CIMMultiRsp
extends CIMItem {
    public static final String DTD_NAME = "MULTIRSP";
    private static final String COUNT_ERROR = "MULTIRSP must have at least two SIMPLERSP subelements";
    private CIMSimpleRspList simpleRsps;

    protected CIMMultiRsp() {
        this.simpleRsps = CIMFactory.simpleRspList();
    }

    protected CIMMultiRsp(CIMSimpleRsp firstRsp, CIMSimpleRsp secondRsp) {
        this();
        if (firstRsp == null || secondRsp == null) {
            throw new NullPointerException(COUNT_ERROR);
        }
        this.simpleRsps.add(firstRsp);
        this.simpleRsps.add(secondRsp);
        if (firstRsp.isReadOnly() || secondRsp.isReadOnly()) {
            firstRsp = (CIMSimpleRsp)firstRsp.getReadOnly();
            secondRsp = (CIMSimpleRsp)secondRsp.getReadOnly();
            this.makeReadOnly();
        }
    }

    protected CIMMultiRsp(CIMSimpleRspList simpleRsps) {
        if (simpleRsps.size() < 2) {
            throw new IllegalArgumentException(COUNT_ERROR);
        }
        this.simpleRsps = simpleRsps;
        if (simpleRsps.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMMultiRsp toWritable() {
        return (CIMMultiRsp)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        this.simpleRsps.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.simpleRsps.size() >= 2;
    }

    public Object clone() {
        CIMMultiRsp clone = (CIMMultiRsp)super.clone();
        clone.simpleRsps = (CIMSimpleRspList)this.simpleRsps.clone();
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void addSimpleRsp(CIMSimpleRsp aSimpleRsp) {
        this.simpleRsps.add(aSimpleRsp.toWritable());
    }

    public CIMSimpleRspList getSimpleRsps() {
        return this.simpleRsps;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.simpleRsps.iterator(), indent);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addMultiRsp(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            this.simpleRsps.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

