/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMMultiReq;
import com.sap.lcr.api.cim.CIMMultiRsp;
import com.sap.lcr.api.cim.CIMSimpleReq;
import com.sap.lcr.api.cim.CIMSimpleRsp;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMMessage
extends CIMItemWA {
    public static final String DTD_NAME = "MESSAGE";
    private String attrId;
    private String attrProtocolVersion;
    private CIMSimpleReq simpleReq;
    private CIMMultiReq multiReq;
    private CIMSimpleRsp simpleRsp;
    private CIMMultiRsp multiRsp;
    private ICIMItem xmlAppender;

    protected CIMMessage() {
    }

    private CIMMessage(String id, String protocolversion) {
        this.attrId = id;
        this.attrProtocolVersion = protocolversion;
    }

    protected CIMMessage(String id, String protocolversion, CIMSimpleReq aCIMSimpleReq) {
        this(id, protocolversion);
        this.checkNonNull(aCIMSimpleReq, "SIMPLEREQ");
        this.simpleReq = aCIMSimpleReq;
        this.xmlAppender = this.simpleReq;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMessage(String id, String protocolversion, CIMMultiReq aCIMMultiReq) {
        this(id, protocolversion);
        this.checkNonNull(aCIMMultiReq, "MULTIREQ");
        this.multiReq = aCIMMultiReq;
        this.xmlAppender = this.multiReq;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMessage(String id, String protocolversion, CIMSimpleRsp aCIMSimpleRsp) {
        this(id, protocolversion);
        this.checkNonNull(aCIMSimpleRsp, "SIMPLERSP");
        this.simpleRsp = aCIMSimpleRsp;
        this.xmlAppender = this.simpleRsp;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMMessage(String id, String protocolversion, CIMMultiRsp aCIMMultiRsp) {
        this(id, protocolversion);
        this.checkNonNull(aCIMMultiRsp, "MULTIRSP");
        this.multiRsp = aCIMMultiRsp;
        this.xmlAppender = this.multiRsp;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void reinit() {
        this.checkWritable();
        this.simpleReq = null;
        this.simpleRsp = null;
        this.multiReq = null;
        this.multiRsp = null;
        this.xmlAppender = null;
    }

    public CIMMessage toWritable() {
        return (CIMMessage)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            this.validateStringForXml(this.attrId, "ID");
            this.validateStringForXml(this.attrProtocolVersion, "PROTOCOLVERSION");
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    boolean isDTDConformant() {
        return this.xmlAppender != null;
    }

    public Object clone() {
        CIMMessage clone = (CIMMessage)super.clone();
        if (this.simpleReq != null) {
            clone.simpleReq = (CIMSimpleReq)this.simpleReq.clone();
            clone.xmlAppender = clone.simpleReq;
        } else if (this.simpleRsp != null) {
            clone.simpleRsp = (CIMSimpleRsp)this.simpleRsp.clone();
            clone.xmlAppender = clone.simpleRsp;
        } else if (this.multiReq != null) {
            clone.multiReq = (CIMMultiReq)this.multiReq.clone();
            clone.xmlAppender = clone.multiReq;
        } else if (this.multiRsp != null) {
            clone.multiRsp = (CIMMultiRsp)this.multiRsp.clone();
            clone.xmlAppender = clone.multiRsp;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setSimpleReq(CIMSimpleReq aSimpleReq) {
        this.checkNonNull(aSimpleReq, "SIMPLEREQ");
        this.reinit();
        this.simpleReq = aSimpleReq.toWritable();
        this.xmlAppender = this.simpleReq;
    }

    public void setSimpleRsp(CIMSimpleRsp aSimpleRsp) {
        this.checkNonNull(aSimpleRsp, "SIMPLERSP");
        this.reinit();
        this.simpleRsp = aSimpleRsp.toWritable();
        this.xmlAppender = this.simpleRsp;
    }

    public void setMultiReq(CIMMultiReq aMultiReq) {
        this.checkNonNull(aMultiReq, "MULTIREQ");
        this.reinit();
        this.multiReq = aMultiReq.toWritable();
        this.xmlAppender = this.multiReq;
    }

    public void setMultiRsp(CIMMultiRsp aMultiRsp) {
        this.checkNonNull(aMultiRsp, "MULTIRSP");
        this.reinit();
        this.multiRsp = aMultiRsp.toWritable();
        this.xmlAppender = this.multiRsp;
    }

    public CIMSimpleReq getSimpleReq() {
        return this.simpleReq;
    }

    public CIMSimpleRsp getSimpleRsp() {
        return this.simpleRsp;
    }

    public CIMMultiReq getMultiReq() {
        return this.multiReq;
    }

    public CIMMultiRsp getMultiRsp() {
        return this.multiRsp;
    }

    public String getId() {
        return this.attrId;
    }

    public void setId(String id) {
        this.checkWritable();
        this.attrId = id == null ? "0" : id;
    }

    public String getProtocolVersion() {
        return this.attrProtocolVersion;
    }

    public void setProtocolVersion(String protVersion) {
        this.checkWritable();
        this.attrProtocolVersion = protVersion != null ? protVersion : "1.0";
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeEscaped(writer, "ID", this.attrId);
        CIMUtil.appendXmlAttributeEscaped(writer, "PROTOCOLVERSION", this.attrProtocolVersion);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("ID".equals(name)) {
                this.attrId = value;
            } else if ("PROTOCOLVERSION".equals(name)) {
                this.attrProtocolVersion = value;
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrId == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("ID", this);
        }
        if (this.attrProtocolVersion == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("PROTOCOLVERSION", this);
        }
    }

    void addSimpleReq(CIMSimpleReq aSimpleReq) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aSimpleReq, this.xmlAppender);
        }
        this.setSimpleReq(aSimpleReq);
    }

    void addSimpleRsp(CIMSimpleRsp aSimpleRsp) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aSimpleRsp, this.xmlAppender);
        }
        this.setSimpleRsp(aSimpleRsp);
    }

    void addMultiReq(CIMMultiReq aMultiReq) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aMultiReq, this.xmlAppender);
        }
        this.setMultiReq(aMultiReq);
    }

    void addMultiRsp(CIMMultiRsp aMultiRsp) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aMultiRsp, this.xmlAppender);
        }
        this.setMultiRsp(aMultiRsp);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addMessage(this);
    }
}

