/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.util.Iterator;

public class CIMKeybindingList
extends CIMUniqueList {
    CIMKeybindingList() {
        super(true);
    }

    CIMKeybindingList(int initialCapacity) {
        super(initialCapacity, true);
    }

    CIMKeybindingList(String[] keys, String[] values, String[] types) {
        this();
        int minIndex = keys.length;
        if (values.length < minIndex) {
            minIndex = values.length;
        }
        try {
            int i = 0;
            while (i < minIndex) {
                String type = "string";
                if (types != null && types.length > i) {
                    type = CIMUtil.cimType2keypropertyType(types[i]);
                }
                if (type == null) {
                    type = "string";
                }
                CIMKeyValue keyValue = CIMFactory.keyValue(values[i], type);
                this.addKeybinding(CIMFactory.keybinding(keys[i], keyValue));
                ++i;
            }
        }
        catch (ItemConstructionExcp ex) {
            throw new InternalError(ex.toString());
        }
    }

    public CIMKeybindingList toWritable() {
        return (CIMKeybindingList)this.getWritable();
    }

    public void addKeybinding(CIMKeybinding aCIMKeybinding) {
        super.add(aCIMKeybinding);
    }

    public CIMKeybinding get(int idx) {
        return (CIMKeybinding)super.getItem(idx);
    }

    public CIMKeybinding get(String name) {
        return (CIMKeybinding)super.getItem(name);
    }

    void addToCIMObjectReference(CIMObjectReference reference) throws ReferenceConversionExcp {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            CIMKeybinding nextBinding = (CIMKeybinding)iter.next();
            nextBinding.addToCIMObjectReference(reference);
        }
    }

    public CIMKeybinding remove(int idx) {
        return (CIMKeybinding)super.removeItem(idx);
    }

    public CIMKeybinding remove(String name) {
        return (CIMKeybinding)super.removeItem(name);
    }
}

