/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMCim;
import com.sap.lcr.api.cim.CIMDeclGroupList;
import com.sap.lcr.api.cim.CIMDeclgroup;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.Xml2CimUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CIMItemMerge {
    private CIMItemMerge() {
    }

    public static void main(String[] args) {
        CIMItemMerge CIMItemMerger = new CIMItemMerge();
        if (args.length < 3) {
            System.out.println("Required parameters:");
            System.out.println("         - Root CIM-XML file (elements are kept)");
            System.out.println("         - New  CIM-XML file (new elements are added)");
            System.out.println("         - Result       file");
            return;
        }
        boolean sortBefore = false;
        if (args.length >= 4 && args[3].equals("sort_before")) {
            sortBefore = true;
        }
        CIMItemMerger.mergeXML(args[0], args[1], args[2], sortBefore);
    }

    public boolean mergeXML(String xmlFirstPath, String xmlSecondPath, String xmlResultPath, boolean sortBefore) {
        CIMItem secondItem;
        CIMItem firstItem;
        try {
            File firstXmlFile = new File(xmlFirstPath);
            FileInputStream firstInputStream = new FileInputStream(firstXmlFile);
            firstItem = Xml2CimUtil.xml2Cim(firstInputStream);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Merge source \"" + xmlFirstPath + "\" not found.");
            fnfe.printStackTrace();
            return false;
        }
        catch (ItemConstructionExcp ice) {
            System.out.println("Failed to create the first item from file \"" + xmlFirstPath + "\"");
            ice.printStackTrace();
            return false;
        }
        try {
            File secondXmlFile = new File(xmlSecondPath);
            FileInputStream secondInputStream = new FileInputStream(secondXmlFile);
            secondItem = Xml2CimUtil.xml2Cim(secondInputStream);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Merge source \"" + xmlFirstPath + "\" not found.");
            fnfe.printStackTrace();
            return false;
        }
        catch (ItemConstructionExcp ice) {
            System.out.println("Failed to create the second item from file \"" + xmlSecondPath + "\"");
            ice.printStackTrace();
            return false;
        }
        if (!firstItem.getClass().getName().equals(secondItem.getClass().getName())) {
            System.out.println("CIM items are not of equal type: " + firstItem.getClass().getName() + " and " + secondItem.getClass().getName());
            return false;
        }
        if (sortBefore && firstItem instanceof CIMCim) {
            CIMCim firstCIMCim = (CIMCim)firstItem;
            CIMDeclGroupList firstDGList = firstCIMCim.getDeclaration().getDeclarationGroups();
            CIMDeclgroup declGroup = (CIMDeclgroup)firstDGList.get(0);
            declGroup.sortClasses();
        }
        try {
            firstItem.mergeWritable(secondItem);
        }
        catch (ItemConstructionExcp ice) {
            System.out.println("Merge of CIM item type " + firstItem.getClass().getName() + " is not supported yet.");
            ice.printStackTrace();
            return false;
        }
        File resultFile = new File(xmlResultPath);
        try {
            FileOutputStream resultStream = new FileOutputStream(resultFile);
            firstItem.appendXml(resultStream, "");
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Unable to open file \"" + xmlResultPath + "\"");
            fnfe.printStackTrace();
            return false;
        }
        catch (SecurityException se) {
            System.out.println("Missing permission to write to file \"" + xmlResultPath + "\"");
            se.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            System.out.println("Error during write to file \"" + xmlResultPath + "\"");
            ioe.printStackTrace();
            return false;
        }
        System.out.println("Merge result written to file \"" + xmlResultPath + "\"");
        return true;
    }
}

