/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyList;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjRef;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMKey;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class CIMInstancename
extends CIMItemWA
implements ICIMObjRef {
    public static final String DTD_NAME = "INSTANCENAME";
    private CIMClassname attrClassName;
    private CIMKeyValue keyvalue;
    private CIMKeybindingList keybindingList;
    private String toStringResult;

    protected CIMInstancename() {
        this.keybindingList = CIMFactory.keybindingList();
    }

    protected CIMInstancename(String aClassname) {
        this();
        this.checkNonNull(aClassname, "CLASSNAME");
        this.attrClassName = CIMFactory.classname(aClassname);
    }

    protected CIMInstancename(CIMClassname aClassname) {
        this();
        this.checkNonNull(aClassname, "CLASSNAME");
        this.attrClassName = aClassname;
    }

    protected CIMInstancename(String aClassname, CIMKeybindingList keyList) {
        this.checkNonNull(aClassname, "CLASSNAME");
        this.attrClassName = CIMFactory.classname(aClassname);
        CIMKeybindingList cIMKeybindingList = this.keybindingList = keyList != null ? keyList : CIMFactory.keybindingList();
        if (this.keybindingList.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMInstancename(String aClassname, String[] keys, String[] values, String[] types) {
        this(aClassname, CIMFactory.keybindingList(keys, values, types));
    }

    protected CIMInstancename(String aClassname, CIMKeyValue aKeyvalue) {
        this(aClassname);
        this.keyvalue = aKeyvalue;
        if (this.keyvalue != null && this.keyvalue.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMInstancename(CIMClassname anAssocName, CIMInstancename leftSide, String leftRole, CIMInstancename rightSide, String rightRole) {
        this(anAssocName);
        if (leftRole == null) {
            throw new NullPointerException("Left role must not be null");
        }
        if (rightRole == null) {
            throw new NullPointerException("Right role must not be null");
        }
        if (leftRole.equalsIgnoreCase(rightRole)) {
            throw new IllegalArgumentException("Duplicate role name: " + leftRole);
        }
        CIMValueReference leftValueReference = CIMFactory.valueReference(leftSide);
        CIMKeybinding leftKeyBinding = CIMFactory.keybinding(leftRole, leftValueReference);
        this.addKeybinding(leftKeyBinding);
        CIMValueReference rightValueReference = CIMFactory.valueReference(rightSide);
        CIMKeybinding rightKeyBinding = CIMFactory.keybinding(rightRole, rightValueReference);
        this.addKeybinding(rightKeyBinding);
    }

    public CIMInstancename toWritable() {
        return (CIMInstancename)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        this.attrClassName.makeReadOnly();
        this.keybindingList.makeReadOnly();
        if (this.keyvalue != null) {
            this.keyvalue.makeReadOnly();
        }
    }

    boolean isDTDConformant() {
        return this.attrClassName != null;
    }

    public Object clone() {
        CIMInstancename clone = (CIMInstancename)super.clone();
        clone.toStringResult = null;
        clone.keybindingList = (CIMKeybindingList)this.keybindingList.clone();
        if (this.keyvalue != null) {
            clone.keyvalue = (CIMKeyValue)this.keyvalue.clone();
        }
        return clone;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMInstancename) {
            CIMInstancename other = (CIMInstancename)aObj;
            if (this.keyvalue != null) {
                return this.equalsForShortName(this, other);
            }
            if (other.keyvalue != null) {
                return this.equalsForShortName(other, this);
            }
            if (this.toStringResult != null && other.toStringResult != null) {
                return this.toStringResult.equals(other.toStringResult);
            }
            return this.equalsNormalized(other);
        }
        return false;
    }

    private boolean equalsForShortName(CIMInstancename shortName, CIMInstancename otherName) {
        CIMKeyValue longKeyValue;
        switch (otherName.getKeybindingList().size()) {
            case 0: {
                longKeyValue = otherName.keyvalue;
                break;
            }
            case 1: {
                CIMKeybinding singleKeyBinding = otherName.getKeybindingList().get(0);
                longKeyValue = singleKeyBinding.getKeyValue();
                break;
            }
            default: {
                return false;
            }
        }
        return shortName.getCIMClassname().equals(otherName.getCIMClassname()) && Util.equals(shortName.keyvalue, longKeyValue);
    }

    private boolean equalsNormalized(CIMInstancename other) {
        if (!this.attrClassName.equals(other.attrClassName)) {
            return false;
        }
        if (this.keybindingList.size() != other.keybindingList.size()) {
            return false;
        }
        int k = 0;
        while (k < this.keybindingList.size()) {
            CIMKeybinding otherKey;
            CIMKeybinding thisKey = this.keybindingList.get(k);
            if (!thisKey.equals(otherKey = other.keybindingList.get(k))) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public int hashCode() {
        return this.toString(true).hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public boolean isAssociation() {
        int k = 0;
        while (k < this.keybindingList.size()) {
            if (this.keybindingList.get(k).getValueReference() != null) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void addKeybinding(CIMKeybinding aKeybinding) {
        this.keybindingList.addKeybinding(aKeybinding);
        this.keyvalue = null;
    }

    public void addKeybinding(String aName, CIMObjectReference aRef) throws ReferenceConversionExcp {
        this.addKeybinding(CIMFactory.keybinding(aName, CIMValueReference.fromCIMObjectReference(aRef)));
    }

    public void setKeyValue(CIMKeyValue aKeyvalue) {
        this.checkWritable();
        this.keyvalue = aKeyvalue == null ? null : aKeyvalue.toWritable();
        this.keybindingList.clear();
    }

    public String getClassname() {
        return this.attrClassName.toDisplayString();
    }

    public CIMClassname getCIMClassname() {
        return this.attrClassName;
    }

    public void setClassname(CIMClassname className) {
        this.checkWritable();
        if (className == null) {
            throw new NullPointerException("CLASSNAME must not be null for INSTANCENAME");
        }
        this.attrClassName = className.toWritable();
    }

    public CIMKeybindingList getKeybindingList() {
        return this.keybindingList;
    }

    public CIMKeyValue getKeyValue() {
        return this.keyvalue;
    }

    public Object getKeyValueByName(String name) {
        return this.getKeybindingValueByName(name);
    }

    public Object getKeybindingValueByName(String name) {
        CIMKeybinding key = this.keybindingList.get(name);
        if (key != null) {
            CIMKeyValue value = key.getKeyValue();
            if (value != null) {
                return value;
            }
            return key.getValueReference();
        }
        return null;
    }

    String toString(boolean comparable) {
        if (comparable && this.toStringResult != null) {
            return this.toStringResult;
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append(this.attrClassName.toString(comparable));
        if (this.keybindingList.size() > 0) {
            boolean first = true;
            Iterator iter = this.keybindingList.iterator();
            while (iter.hasNext()) {
                CIMKeybinding kb = (CIMKeybinding)iter.next();
                if (first) {
                    buf.append('.');
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(comparable ? kb.getName().toLowerCase() : kb.getName());
                buf.append('=');
                CIMKeyValue keyVal = kb.getKeyValue();
                if (keyVal != null) {
                    String type = keyVal.getType();
                    if ("string".equals(type)) {
                        CIMUtil.appendMaskedValue(buf, keyVal.getValue());
                        continue;
                    }
                    if ("boolean".equals(type)) {
                        buf.append(keyVal.getValue().toLowerCase());
                        continue;
                    }
                    buf.append(keyVal.getValue());
                    continue;
                }
                String ref = kb.getValueReference().toString(comparable);
                buf.append("ref");
                CIMUtil.appendMaskedValue(buf, ref);
            }
        } else if (this.keyvalue != null) {
            String type = this.keyvalue.getType();
            buf.append('=');
            if ("string".equals(type)) {
                CIMUtil.appendMaskedValue(buf, this.keyvalue.getValue());
            } else if ("boolean".equals(type)) {
                buf.append(this.keyvalue.getValue().toLowerCase());
            } else {
                buf.append(this.keyvalue.getValue());
            }
        } else {
            buf.append("=@");
        }
        String result = buf.toString();
        if (comparable && this.isReadOnly()) {
            this.toStringResult = result;
        }
        return result;
    }

    public CIMInstance newCIMInstance(CIMClass cls) throws LcrException {
        String classname = cls.getClassname();
        if (!this.attrClassName.equals(cls.getCIMClassname())) {
            throw new LcrException("Wrong class definition (class: {0}, class of instance: {1})", new String[]{classname, this.attrClassName.toDisplayString()});
        }
        CIMInstance newInstance = cls.createInstanceTemplate();
        if (this.keyvalue != null) {
            CIMPropertyList clsKeyProps = cls.getKeyProperties();
            int keyPropCount = clsKeyProps.size();
            int propRefCount = cls.getPropertyReferences().size();
            if (keyPropCount != 1 || propRefCount > 0) {
                throw new LcrException("Unable to resolve unknown key property name for class {0} ({1} key properties, {2} property references)", new String[]{classname, Integer.toString(keyPropCount), Integer.toString(propRefCount)});
            }
            String keyName = clsKeyProps.get(0).getName();
            CIMProperty instProp = newInstance.getPropertyByName(keyName);
            if (instProp == null) {
                throw new LcrException("Unknown property {0} defined in {1}", new String[]{keyName, this.toDisplayString()});
            }
            instProp.setValue(this.keyvalue.getValue());
        } else {
            Iterator iter = this.keybindingList.iterator();
            while (iter.hasNext()) {
                CIMKeybinding nextKeybinding = (CIMKeybinding)iter.next();
                String nextName = nextKeybinding.getName();
                CIMValueReference ref = nextKeybinding.getValueReference();
                if (ref != null) {
                    CIMPropertyReference instPropRef = newInstance.getPropertyReferenceByName(nextName);
                    if (instPropRef == null) {
                        throw new LcrException("Unknown property reference {0} defined in {1}", new String[]{nextName, this.toDisplayString()});
                    }
                    instPropRef.setValueReference((CIMValueReference)ref.clone());
                    continue;
                }
                CIMKeyValue nextKeyValue = nextKeybinding.getKeyValue();
                CIMProperty instProp = newInstance.getPropertyByName(nextName);
                if (instProp == null) {
                    throw new LcrException("Unknown property {0} defined in {1}", new String[]{nextName, this.toDisplayString()});
                }
                instProp.setValue(nextKeyValue.getValue());
            }
        }
        return newInstance;
    }

    public boolean isEqualTo(CIMInstancename anInstanceName) {
        return this.equals(anInstanceName);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        if (this.keybindingList.size() != 0) {
            this.appendXml(writer, DTD_NAME, this.keybindingList, indent);
        } else if (this.keyvalue != null) {
            this.appendXml(writer, DTD_NAME, this.keyvalue, indent);
        } else {
            this.appendXml(writer, DTD_NAME, indent);
        }
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "CLASSNAME", this.attrClassName.toDisplayString());
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"CLASSNAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrClassName = CIMFactory.classname(value);
            ++i;
        }
        if (this.attrClassName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("CLASSNAME", this);
        }
    }

    void addKeyValue(CIMKeyValue aKeyvalue) throws ItemConstructionExcp {
        if (this.keybindingList.size() != 0) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aKeyvalue, this.keybindingList.get(0));
        }
        this.setKeyValue(aKeyvalue);
    }

    void addValueReference(CIMValueReference aValueReference) throws ItemConstructionExcp {
        throw new ItemConstructionExcp("Single VALUE.REFERENCE subelement impossible for INSTANCENAME in CIM");
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addInstancename(this);
    }

    public boolean equals(String aInstancename) {
        if (aInstancename == null) {
            return false;
        }
        try {
            CIMInstancename other = CIMFactory.createInstancenameFromString(aInstancename);
            return this.equals(other.makeReadOnly());
        }
        catch (LcrException ex) {
            return false;
        }
    }

    public CIMValueReference createValueReference() {
        return CIMFactory.valueReference(this);
    }

    public CIMObjectReference toCIMObjectReference() throws ReferenceConversionExcp {
        CIMObjectReference reference = new CIMObjectReference(this.attrClassName.toDisplayString());
        if (this.keyvalue != null) {
            CIMKeybinding keyBinding = CIMFactory.keybinding("", this.keyvalue.getValue());
            keyBinding.addToCIMObjectReference(reference);
        } else if (this.keybindingList != null && this.keybindingList.size() != 0) {
            this.keybindingList.addToCIMObjectReference(reference);
        } else {
            reference.addCIMKey(CIMKey.SINGLETON);
        }
        return reference;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.attrClassName != null) {
                this.attrClassName.validateCharacters(includeNames);
            }
            if (this.keyvalue != null) {
                this.keyvalue.validateCharacters(includeNames);
            }
            this.keybindingList.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

