/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyArrayList;
import com.sap.lcr.api.cim.CIMPropertyList;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMPropertyReferenceList;
import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMObject;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class CIMInstance
extends CIMItemWAWQ
implements ICIMObject {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMInstance == null ? (class$com$sap$lcr$api$cim$CIMInstance = CIMInstance.class$("com.sap.lcr.api.cim.CIMInstance")) : class$com$sap$lcr$api$cim$CIMInstance).getName());
    public static final String DTD_NAME = "INSTANCE";
    private CIMClassname attrClassName;
    private CIMPropertyList properties = CIMFactory.propertyList();
    private CIMPropertyArrayList propertyArrays = CIMFactory.propertyArrayList();
    private CIMPropertyReferenceList propertyReferences = CIMFactory.propertyReferenceList();
    private boolean isAssociationInstance;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMInstance;

    protected CIMInstance() {
    }

    protected CIMInstance(String aClassname) {
        this();
        this.checkNonNull(aClassname, "CLASSNAME");
        this.attrClassName = CIMFactory.classname(aClassname);
    }

    protected CIMInstance(CIMClassname aClassname) {
        this();
        this.checkNonNull(aClassname, "CLASSNAME");
        this.attrClassName = aClassname;
    }

    protected CIMInstance(String aClassname, String propName, String propValue, String propType) throws ItemConstructionExcp {
        this(aClassname);
        this.initProperty(propName, propValue, propType);
    }

    protected CIMInstance(String aClassname, String[] propNames, String[] propValues, String[] propTypes) throws ItemConstructionExcp {
        this(aClassname);
        this.initProperties(propNames, propValues, propTypes);
    }

    protected CIMInstance(CIMClassname anAssocName, CIMInstancename leftSide, String leftRole, CIMInstancename rightSide, String rightRole) {
        this(anAssocName);
        if (leftRole == null) {
            throw new NullPointerException("Left role must not be null");
        }
        if (rightRole == null) {
            throw new NullPointerException("Right role must not be null");
        }
        if (leftRole.equalsIgnoreCase(rightRole)) {
            throw new IllegalArgumentException("Duplicate role name: " + leftRole);
        }
        CIMValueReference leftValueReference = CIMFactory.valueReference(leftSide);
        CIMPropertyReference leftPropertyReference = CIMFactory.propertyReference(leftRole, leftValueReference);
        this.addPropertyReference(leftPropertyReference);
        CIMValueReference rightValueReference = CIMFactory.valueReference(rightSide);
        CIMPropertyReference rightPropertyReference = CIMFactory.propertyReference(rightRole, rightValueReference);
        this.addPropertyReference(rightPropertyReference);
    }

    public CIMInstance toWritable() {
        return (CIMInstance)this.getWritable();
    }

    void makeSubelementsReadOnlyWOQualifiers() {
        this.attrClassName.makeReadOnly();
        this.properties.makeReadOnly();
        this.propertyArrays.makeReadOnly();
        this.propertyReferences.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.attrClassName != null;
    }

    public final Object clone(boolean includeQualifiers) {
        return this.clone(false, includeQualifiers, true, null, null);
    }

    public final Object clone(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propertyList) {
        return this.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList, null);
    }

    public Object clone(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propsIncluded, CanonicalizedStrings propsExcluded) {
        CIMInstance clone = (CIMInstance)super.clone(includeQualifiers);
        clone.propertyReferences = (CIMPropertyReferenceList)this.propertyReferences.clone(localOnly, includeQualifiers, includeClassOrigin, propsIncluded, propsExcluded);
        clone.propertyArrays = (CIMPropertyArrayList)this.propertyArrays.clone(localOnly, includeQualifiers, includeClassOrigin, propsIncluded, propsExcluded);
        clone.properties = (CIMPropertyList)this.properties.clone(localOnly, includeQualifiers, includeClassOrigin, propsIncluded, propsExcluded);
        return clone;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMInstance) {
                CIMInstance other = (CIMInstance)obj;
                try {
                    return this.attrClassName.equals(other.attrClassName) && this.properties.equals(other.properties) && this.propertyArrays.equals(other.propertyArrays) && this.propertyReferences.equals(other.propertyReferences) && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMInstance", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrClassName.hashCode();
    }

    private void initProperties(String[] names, String[] values, String[] types) throws ItemConstructionExcp {
        int maxlen = names.length > values.length ? values.length : names.length;
        int i = 0;
        while (i < maxlen) {
            String propType = types != null && i < types.length ? types[i] : "string";
            this.initProperty(names[i], values[i], propType);
            ++i;
        }
    }

    private void initProperty(String key, String value, String type) throws ItemConstructionExcp {
        CIMProperty theProperty = CIMFactory.property(key, type);
        CIMValue theValue = CIMFactory.value(value);
        theProperty.addValue(theValue);
        this.addProperty(theProperty);
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        subelements.addIterator(this.getQualifiers());
        subelements.addIterator(this.properties);
        subelements.addIterator(this.propertyArrays);
        subelements.addIterator(this.propertyReferences);
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "CLASSNAME", this.attrClassName.toDisplayString());
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMInstance)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMInstance source = (CIMInstance)sourceItem;
        this.mergeQualifiersWritable(source);
        Iterator sourceIter = source.properties.iterator();
        while (sourceIter.hasNext()) {
            CIMProperty sourceProperty = (CIMProperty)sourceIter.next();
            String sourcePropertyName = sourceProperty.getName();
            CIMProperty targetProperty = this.getPropertyByName(sourcePropertyName);
            if (targetProperty != null) {
                targetProperty.merge(sourceProperty);
                continue;
            }
            this.properties.add((CIMProperty)sourceProperty.clone());
        }
        Iterator sourceIter2 = source.propertyArrays.iterator();
        while (sourceIter2.hasNext()) {
            CIMPropertyArray sourcePropertyArray = (CIMPropertyArray)sourceIter2.next();
            String sourcePropertyArrayName = sourcePropertyArray.getName();
            CIMPropertyArray targetPropertyArray = this.getPropertyArrayByName(sourcePropertyArrayName);
            if (targetPropertyArray != null) {
                targetPropertyArray.merge(sourcePropertyArray);
                continue;
            }
            this.propertyArrays.add((CIMPropertyArray)sourcePropertyArray.clone());
        }
        Iterator sourceIter3 = source.propertyReferences.iterator();
        while (sourceIter3.hasNext()) {
            CIMPropertyReference sourcePropertyReference = (CIMPropertyReference)sourceIter3.next();
            String sourcePropertyReferenceName = sourcePropertyReference.getName();
            CIMPropertyReference targetPropertyReference = this.getPropertyReferenceByName(sourcePropertyReferenceName);
            if (targetPropertyReference != null) {
                targetPropertyReference.merge(sourcePropertyReference);
                continue;
            }
            this.propertyReferences.add((CIMPropertyReference)sourcePropertyReference.clone());
        }
    }

    public void declareAsAssociation(boolean isAssoc) {
        this.checkWritable();
        this.isAssociationInstance = isAssoc;
    }

    public void setClassname(CIMClassname className) {
        this.checkWritable();
        this.attrClassName = className.toWritable();
    }

    public CIMPropertyList getKeyProperties(CIMClass cls) throws LcrException {
        if (!cls.getCIMClassname().equals(this.getCIMClassname())) {
            throw new LcrException("Class name mismatch (class, instance): " + cls.getClassname() + ", " + this.getClassname());
        }
        CIMPropertyList clsKeyProps = cls.getKeyProperties();
        int size = clsKeyProps.size();
        CIMPropertyList resultList = CIMFactory.propertyList(size);
        int i = 0;
        while (i < size) {
            String name = clsKeyProps.get(i).getName();
            CIMProperty instProp = this.properties.get(name);
            if (instProp == null) {
                throw new LcrException("Instance missing property: " + name);
            }
            resultList.add(instProp);
            ++i;
        }
        return resultList;
    }

    public void adaptToNewName(CIMInstancename newInstanceName) throws LcrException {
        if (!this.attrClassName.equals(newInstanceName.getCIMClassname())) {
            throw new LcrException("Cannot adapt this instance of class {0} to a new instance name of another class: {1}", new String[]{this.attrClassName.toDisplayString(), newInstanceName.toDisplayString()});
        }
        if (newInstanceName.getKeyValue() != null) {
            throw new LcrException("Unknown name of key property: New instance name has a KEYVALUE subelement ({0})", new String[]{newInstanceName.toDisplayString()});
        }
        this.checkWritable();
        CIMKeybindingList keys = newInstanceName.getKeybindingList();
        int size = keys.size();
        int i = 0;
        while (i < size) {
            CIMKeybinding key = keys.get(i);
            String name = key.getName();
            CIMKeyValue keyvalue = key.getKeyValue();
            if (keyvalue != null) {
                CIMProperty prop = this.properties.get(name);
                if (prop == null) {
                    throw new LcrException("Missing key property {0}. Instance cannot be adapted to this new name: {1}", new String[]{name, newInstanceName.toDisplayString()});
                }
                String value = keyvalue.getValue();
                if (!value.equals(prop.getValue())) {
                    prop.setValue(value);
                }
            } else {
                CIMValueReference valRef = key.getValueReference();
                if (valRef != null) {
                    CIMPropertyReference propRef = this.propertyReferences.get(name);
                    if (propRef == null) {
                        throw new LcrException("Missing property reference {0}.  Instance cannot be adapted to this new name: {1}", new String[]{name, newInstanceName.toDisplayString()});
                    }
                    if (!valRef.equals(propRef.getValueReference())) {
                        propRef.setValueReference((CIMValueReference)valRef.clone());
                    }
                } else {
                    throw new LcrException("Cannot adapt instance to new name. The new name is invalid.");
                }
            }
            ++i;
        }
    }

    public CIMInstancename buildInstanceName(CIMClass cls) throws LcrException {
        if (!cls.getCIMClassname().equals(this.attrClassName)) {
            throw new LcrException("Wrong class definition: {0}, {1} needed", new Object[]{cls.getClassname(), this.attrClassName.toDisplayString()});
        }
        if (cls.isIndication()) {
            throw new LcrException("Indications can not have an instance name");
        }
        CIMInstancename newInstanceName = CIMFactory.instancename(cls.getCIMClassname().toDisplayString());
        CIMPropertyList clsPropList = cls.getProperties();
        int clsPropCount = clsPropList.size();
        int i = 0;
        while (i < clsPropCount) {
            CIMProperty classProp = clsPropList.get(i);
            if (classProp.isKeyProperty()) {
                String clsPropName = classProp.getName();
                CIMProperty instProp = this.properties.get(clsPropName);
                if (instProp == null) {
                    throw new LcrException("Cannot build instance name, missing key property {0}.{1}", new String[]{cls.getClassname(), clsPropName});
                }
                CIMValue instValue = instProp.getCIMValue();
                if (instValue == null) {
                    throw new LcrException("Cannot build instance name, missing value for key property {0}.{1}", new String[]{cls.getClassname(), clsPropName});
                }
                try {
                    CIMKeybinding kb = CIMFactory.keybinding(clsPropName, instProp.getType(), instValue.getStringvalue());
                    newInstanceName.addKeybinding(kb);
                }
                catch (ItemConstructionExcp ex) {
                    throw new LcrException(ex);
                }
            }
            ++i;
        }
        CIMPropertyReferenceList clsPropRefList = cls.getPropertyReferences();
        int clsPropRefCount = clsPropRefList.size();
        int i2 = 0;
        while (i2 < clsPropRefCount) {
            CIMPropertyReference classPropRef = clsPropRefList.get(i2);
            String propRefName = classPropRef.getName();
            CIMPropertyReference instPropRef = this.propertyReferences.get(propRefName);
            if (instPropRef == null) {
                throw new LcrException("Cannot build instance name, missing property reference {0}.{1}", new String[]{cls.getClassname(), propRefName});
            }
            CIMValueReference instValueRef = instPropRef.getValueReference();
            if (instValueRef == null) {
                throw new LcrException("Cannot build instance name, missing value reference for property reference {0}.{1}", new String[]{cls.getClassname(), propRefName});
            }
            CIMKeybinding kb = CIMFactory.keybinding(propRefName, (CIMValueReference)instValueRef.clone());
            newInstanceName.addKeybinding(kb);
            ++i2;
        }
        return newInstanceName;
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"CLASSNAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrClassName = CIMFactory.classname(value);
            ++i;
        }
        if (this.attrClassName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("CLASSNAME", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addInstance(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.attrClassName != null) {
                this.attrClassName.validateCharacters(includeNames);
            }
            this.properties.validateCharacters(includeNames);
            this.propertyArrays.validateCharacters(includeNames);
            this.propertyReferences.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    public final String getClassname() {
        return this.attrClassName.toDisplayString();
    }

    public final CIMClassname getCIMClassname() {
        return this.attrClassName;
    }

    public final boolean isAssociation() {
        return this.isAssociationInstance || this.propertyReferences.size() > 0;
    }

    public final String getDisplayName() {
        String value;
        CIMProperty prop = this.getPropertyByName("Caption");
        if (prop != null && (value = prop.getValue()) != null && value.length() != 0) {
            return value;
        }
        if (this.isAssociationInstance) {
            return "Instance of " + this.attrClassName;
        }
        return "(caption not set)";
    }

    public final void addProperty(CIMProperty aProperty) {
        this.properties.add(aProperty);
    }

    public final void addPropertyArray(CIMPropertyArray aPropertyArray) {
        this.propertyArrays.add(aPropertyArray);
    }

    public final void addPropertyReference(CIMPropertyReference aPropertyReference) {
        this.propertyReferences.add(aPropertyReference);
        this.isAssociationInstance = true;
    }

    public final void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public final void removePropertyArray(String propertyArrayName) {
        this.propertyArrays.remove(propertyArrayName);
    }

    public final void removePropertyReference(String propertyReferenceName) {
        this.propertyReferences.remove(propertyReferenceName);
    }

    public final CIMProperty getPropertyByName(String propertyName) {
        return this.properties.get(propertyName);
    }

    public final String getPropertyValue(String aPropertyName) {
        CIMProperty prop = this.getPropertyByName(aPropertyName);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public final CIMPropertyArray getPropertyArrayByName(String propertyArrayName) {
        return this.propertyArrays.get(propertyArrayName);
    }

    public final CIMPropertyReference getPropertyReferenceByName(String propertyReferenceName) {
        return this.propertyReferences.get(propertyReferenceName);
    }

    public final CIMPropertyList getProperties() {
        return this.properties;
    }

    public final CIMPropertyArrayList getPropertyArrays() {
        return this.propertyArrays;
    }

    public final CIMPropertyReferenceList getPropertyReferences() {
        return this.propertyReferences;
    }

    public final Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public final Iterator getPropertyArrayIterator() {
        return this.propertyArrays.iterator();
    }

    public final Iterator getPropertyReferenceIterator() {
        return this.propertyReferences.iterator();
    }

    public final CIMUniqueList getPropertiesByType(int index) {
        switch (index) {
            case 0: {
                return this.properties;
            }
            case 1: {
                return this.propertyReferences;
            }
            case 2: {
                return this.propertyArrays;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index value: " + index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

