/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMError;
import com.sap.lcr.api.cim.CIMIReturnValue;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMIMethodResponse
extends CIMItemWA
implements ICIMNamedElement {
    public static final String DTD_NAME = "IMETHODRESPONSE";
    private String attrName;
    private CIMError error;
    private CIMIReturnValue iReturnValue;
    private ICIMItem xmlAppender;

    protected CIMIMethodResponse() {
    }

    protected CIMIMethodResponse(String aCIMName) {
        this();
        this.checkNonNull(aCIMName, "NAME");
        this.attrName = aCIMName;
    }

    protected CIMIMethodResponse(String aCIMName, CIMError aCIMError) {
        this(aCIMName);
        this.error = aCIMError;
        this.xmlAppender = this.error;
        if (this.error != null && this.error.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMIMethodResponse(String aCIMName, CIMIReturnValue aCIMIReturnValue) {
        this(aCIMName);
        this.iReturnValue = aCIMIReturnValue;
        this.xmlAppender = this.iReturnValue;
        if (this.iReturnValue != null && this.iReturnValue.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMIMethodResponse toWritable() {
        return (CIMIMethodResponse)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.error != null) {
            this.error.makeReadOnly();
        }
        if (this.iReturnValue != null) {
            this.iReturnValue.makeReadOnly();
        }
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.error != null) {
                this.error.validateCharacters(includeNames);
            }
            if (this.iReturnValue != null) {
                this.iReturnValue.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public Object clone() {
        CIMIMethodResponse clone = (CIMIMethodResponse)super.clone();
        if (this.error != null) {
            clone.error = (CIMError)this.error.clone();
            clone.xmlAppender = clone.error;
        } else if (this.iReturnValue != null) {
            clone.iReturnValue = (CIMIReturnValue)this.iReturnValue.clone();
            clone.xmlAppender = clone.iReturnValue;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    public void setError(CIMError anError) {
        this.checkWritable();
        this.error = anError.toWritable();
        this.xmlAppender = this.error;
        this.iReturnValue = null;
    }

    public void setIReturnValue(CIMIReturnValue aIReturnValue) {
        this.checkWritable();
        this.error = null;
        if (aIReturnValue != null) {
            aIReturnValue = aIReturnValue.toWritable();
        }
        this.iReturnValue = aIReturnValue;
        this.xmlAppender = this.iReturnValue;
    }

    public CIMError getError() {
        return this.error;
    }

    public CIMIReturnValue getIReturnValue() {
        return this.iReturnValue;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void addError(CIMError anError) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, this.error, this.xmlAppender);
        }
        this.setError(anError);
    }

    void addIReturnValue(CIMIReturnValue aIReturnValue) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aIReturnValue, this.xmlAppender);
        }
        this.setIReturnValue(aIReturnValue);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addIMethodResponse(this);
    }
}

