/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMError
extends CIMItemWA {
    public static final String DTD_NAME = "ERROR";
    private int attrCode;
    private String attrDescription;

    protected CIMError() {
    }

    protected CIMError(int code) {
        this();
        this.attrCode = code;
    }

    protected CIMError(int code, String aDescription) {
        this(code);
        this.setDescription(aDescription);
    }

    public CIMError toWritable() {
        return (CIMError)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return true;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setDescription(String aDescription) {
        this.checkWritable();
        this.attrDescription = CIMUtil.escapeCharactersInvalidForXml(aDescription);
    }

    public int getErrorCode() {
        return this.attrCode;
    }

    public String getDescription() {
        return this.attrDescription == null ? "" : this.attrDescription;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttribute(writer, "CODE", this.attrCode);
        if (this.attrDescription != null) {
            CIMUtil.appendXmlAttributeEscaped(writer, "DESCRIPTION", this.attrDescription);
        }
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        boolean attrCodeFound = false;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("CODE".equals(name)) {
                try {
                    this.attrCode = Integer.parseInt(value);
                    attrCodeFound = true;
                }
                catch (NumberFormatException nfe) {
                    throw ItemConstructionExcp.createInvalidIntegerAttributeExcp(value, "CODE", this);
                }
            } else if ("DESCRIPTION".equals(name)) {
                this.attrDescription = value;
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (!attrCodeFound) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("CODE", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addError(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            this.validateStringForXml(this.attrDescription, "DESCRIPTION");
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

