/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMMethod;
import com.sap.lcr.api.cim.CIMMethodList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyArrayList;
import com.sap.lcr.api.cim.CIMPropertyList;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMPropertyReferenceList;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.CIMUniqueList;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CanonicalizedStrings;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ICIMObject;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import com.sap.lcr.api.cim.PrependingIterator;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class CIMClass
extends CIMItemWAWQ
implements ICIMObject,
ICIMNamedElement {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMClass == null ? (class$com$sap$lcr$api$cim$CIMClass = CIMClass.class$("com.sap.lcr.api.cim.CIMClass")) : class$com$sap$lcr$api$cim$CIMClass).getName());
    private static final String[] PREPEND_QUALIFIER_NAMES = new String[]{"ASSOCIATION", "Aggregation", "INDICATION"};
    public static final String DTD_NAME = "CLASS";
    private CIMClassname attrName;
    private CIMClassname attrSuperClass;
    private CIMPropertyList properties = CIMFactory.propertyList();
    private CIMPropertyArrayList propertyArrays = CIMFactory.propertyArrayList();
    private CIMPropertyReferenceList propertyReferences = CIMFactory.propertyReferenceList();
    private CIMMethodList methods = CIMFactory.methodList();
    private PropagationMap propagationMap;
    private boolean noPropagationMapRebuild;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMClass;

    protected CIMClass() {
    }

    protected CIMClass(CIMClassname aClassname, CIMClassname aSuperclassname) {
        this();
        this.checkNonNull(aClassname, "NAME");
        this.attrName = aClassname;
        this.attrSuperClass = aSuperclassname;
    }

    public CIMClass toWritable() {
        return (CIMClass)this.getWritable();
    }

    void makeSubelementsReadOnlyWOQualifiers() {
        this.attrName.makeReadOnly();
        if (this.attrSuperClass != null) {
            this.attrSuperClass.makeReadOnly();
        }
        this.methods.makeReadOnly();
        this.properties.makeReadOnly();
        this.propertyArrays.makeReadOnly();
        this.propertyReferences.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public final Object clone(boolean includeQualifiers) {
        return this.clone(false, includeQualifiers, true, null);
    }

    public Object clone(boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, CanonicalizedStrings propertyList) {
        CIMClass clone = (CIMClass)super.clone(includeQualifiers);
        clone.properties = (CIMPropertyList)this.properties.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
        clone.propertyArrays = (CIMPropertyArrayList)this.propertyArrays.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
        clone.propertyReferences = (CIMPropertyReferenceList)this.propertyReferences.clone(localOnly, includeQualifiers, includeClassOrigin, propertyList);
        clone.methods = (CIMMethodList)this.methods.clone(localOnly, includeQualifiers, includeClassOrigin);
        clone.propagationMap = null;
        clone.noPropagationMapRebuild = false;
        return clone;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMClass) {
                CIMClass other = (CIMClass)obj;
                try {
                    return this.attrName.equals(other.attrName) && Util.equals(this.attrSuperClass, other.attrSuperClass) && this.properties.equals(other.properties) && this.propertyArrays.equals(other.propertyArrays) && this.propertyReferences.equals(other.propertyReferences) && this.getQualifiers().equals(other.getQualifiers()) && this.methods.equals(other.methods);
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMClass", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void addMethod(CIMMethod aMethod) {
        this.methods.add(aMethod);
    }

    public void declareAsAssociation() {
        this.checkWritable();
        try {
            CIMQualifier assocQualifier = CIMFactory.qualifier("ASSOCIATION", "boolean", CIMFactory.value("true"));
            this.addQualifier(assocQualifier);
        }
        catch (ItemConstructionExcp ex) {
            throw new InternalError(ex.toString());
        }
    }

    public String getSuperclassname() {
        return this.attrSuperClass == null ? null : this.attrSuperClass.toDisplayString();
    }

    public void setSuperclassname(String superClassName) {
        this.checkWritable();
        this.attrSuperClass = superClassName == null ? null : CIMFactory.classname(superClassName);
    }

    public void setSuperclassname(CIMClassname superClassName) {
        this.checkWritable();
        this.attrSuperClass = superClassName != null ? superClassName.toWritable() : null;
    }

    public CIMClassname getCIMSuperclassname() {
        return this.attrSuperClass;
    }

    public boolean isAbstractClass() {
        String abstractValue = this.getQualifierValue("Abstract");
        boolean isAbstract = "true".equalsIgnoreCase(abstractValue);
        return isAbstract;
    }

    public boolean isIndication() {
        CIMQualifier qual = this.getQualifierByName("INDICATION");
        if (qual == null) {
            return false;
        }
        CIMValue value = qual.getCIMValue();
        return value == null ? false : value.isTrue();
    }

    public CIMMethod getMethodByName(String methodName) {
        return this.methods.get(methodName);
    }

    public CIMMethodList getMethods() {
        return this.methods;
    }

    public Iterator getMethodIterator() {
        return this.methods.iterator();
    }

    public CIMPropertyList getKeyProperties() {
        CIMPropertyList list = CIMFactory.propertyList();
        int size = this.properties.size();
        int i = 0;
        while (i < size) {
            CIMProperty prop = this.properties.get(i);
            if (prop.isKeyProperty()) {
                list.add(prop);
            }
            ++i;
        }
        return list;
    }

    public ArrayList getPropertyList() {
        ArrayList<String> result = new ArrayList<String>();
        String nextEntry = this.isAbstractClass() ? "class abstract " + this.getClassname() : "class real " + this.getClassname();
        String superclassname = this.getSuperclassname();
        if (superclassname != null) {
            nextEntry = nextEntry + " " + superclassname;
        }
        result.add(nextEntry);
        Iterator anIter = this.properties.iterator();
        while (anIter.hasNext()) {
            CIMProperty aProp = (CIMProperty)anIter.next();
            String keyProperty = aProp.isKeyProperty() ? "key" : "nokey";
            result.add("property " + aProp.getName() + " " + aProp.getType() + " " + keyProperty + " " + aProp.getClassOrigin());
        }
        return result;
    }

    public ArrayList getPropertyReferenceList() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator anIter = this.propertyReferences.iterator();
        while (anIter.hasNext()) {
            CIMPropertyReference aProp = (CIMPropertyReference)anIter.next();
            String keyProperty = aProp.isKeyProperty() ? "key" : "nokey";
            result.add("property " + aProp.getName() + " " + "reference" + " " + keyProperty + " " + aProp.getClassOrigin());
        }
        return result;
    }

    public ArrayList getPropertyArrayList() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator anIter = this.propertyArrays.iterator();
        while (anIter.hasNext()) {
            CIMPropertyArray aProp = (CIMPropertyArray)anIter.next();
            result.add("propertyarray " + aProp.getName() + " " + aProp.getType() + " " + "nokey " + aProp.getClassOrigin());
        }
        return result;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        subelements.addIterator(new PrependingIterator(this.getQualifiers(), PREPEND_QUALIFIER_NAMES));
        subelements.addIterator(this.properties);
        subelements.addIterator(this.propertyArrays);
        subelements.addIterator(this.propertyReferences);
        subelements.addIterator(this.methods);
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName.toDisplayString());
        if (this.attrSuperClass != null) {
            CIMUtil.appendXmlAttributeUnescaped(writer, "SUPERCLASS", this.attrSuperClass.toDisplayString());
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMClass)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMClass source = (CIMClass)sourceItem;
        if (this.attrSuperClass == null) {
            this.attrSuperClass = source.attrSuperClass;
            if (this.attrSuperClass != null) {
                this.attrSuperClass = (CIMClassname)this.attrSuperClass.clone();
            }
        }
        this.mergeQualifiersWritable(source);
        Iterator sourceIter = source.properties.iterator();
        while (sourceIter.hasNext()) {
            CIMProperty sourceProperty = (CIMProperty)sourceIter.next();
            String sourcePropertyName = sourceProperty.getName();
            CIMProperty targetProperty = this.getPropertyByName(sourcePropertyName);
            if (targetProperty != null) {
                targetProperty.merge(sourceProperty);
                continue;
            }
            this.properties.add((CIMProperty)sourceProperty.clone());
        }
        Iterator sourceIter2 = source.propertyArrays.iterator();
        while (sourceIter2.hasNext()) {
            CIMPropertyArray sourcePropertyArray = (CIMPropertyArray)sourceIter2.next();
            String sourcePropertyArrayName = sourcePropertyArray.getName();
            CIMPropertyArray targetPropertyArray = this.getPropertyArrayByName(sourcePropertyArrayName);
            if (targetPropertyArray != null) {
                targetPropertyArray.merge(sourcePropertyArray);
                continue;
            }
            this.propertyArrays.add((CIMPropertyArray)sourcePropertyArray.clone());
        }
        Iterator sourceIter3 = source.propertyReferences.iterator();
        while (sourceIter3.hasNext()) {
            CIMPropertyReference sourcePropertyReference = (CIMPropertyReference)sourceIter3.next();
            String sourcePropertyReferenceName = sourcePropertyReference.getName();
            CIMPropertyReference targetPropertyReference = this.getPropertyReferenceByName(sourcePropertyReferenceName);
            if (targetPropertyReference != null) {
                targetPropertyReference.merge(sourcePropertyReference);
                continue;
            }
            this.propertyReferences.add((CIMPropertyReference)sourcePropertyReference.clone());
        }
        Iterator sourceIter4 = source.methods.iterator();
        while (sourceIter4.hasNext()) {
            CIMMethod sourceMethod = (CIMMethod)sourceIter4.next();
            String sourceMethodName = sourceMethod.getName();
            CIMMethod targetMethod = this.getMethodByName(sourceMethodName);
            if (targetMethod != null) {
                targetMethod.merge(sourceMethod);
                continue;
            }
            this.methods.add((CIMMethod)sourceMethod.clone());
        }
    }

    public CIMInstance createInstanceTemplate() {
        CIMInstance instTemplate = CIMFactory.instance(this.attrName.toDisplayString());
        CIMPropertyList instProps = instTemplate.getProperties();
        instProps.addAll((CIMPropertyList)this.properties.clone(false, false, true, null));
        CIMPropertyArrayList instPropArrays = instTemplate.getPropertyArrays();
        instPropArrays.addAll((CIMPropertyArrayList)this.propertyArrays.clone(false, false, true, null));
        int p = 0;
        while (p < this.propertyReferences.size()) {
            CIMPropertyReference clsPropRef = this.propertyReferences.get(p);
            CIMPropertyReference newPropRef = CIMFactory.propertyReference(clsPropRef.getName());
            newPropRef.setClassOrigin(clsPropRef.getClassOrigin());
            newPropRef.setPropagated(clsPropRef.isPropagated());
            instTemplate.addPropertyReference(newPropRef);
            ++p;
        }
        return instTemplate;
    }

    public PropagationMap getPropagationMap(boolean rebuild) throws LcrException {
        if (rebuild && !this.noPropagationMapRebuild) {
            this.propagationMap = null;
        }
        if (this.propagationMap != null) {
            return this.propagationMap;
        }
        if (this.isReadOnly()) {
            this.noPropagationMapRebuild = true;
        }
        this.propagationMap = new PropagationMap();
        int i = 0;
        while (i < this.properties.size()) {
            CIMProperty prop = this.properties.get(i);
            CIMQualifier qualPropagated = prop.getQualifierByName("Propagated");
            if (qualPropagated != null) {
                String propagatedProp;
                String propagatedClass;
                String value = qualPropagated.getValue();
                int p = value.indexOf(46);
                if (p == -1) {
                    propagatedClass = null;
                    propagatedProp = value;
                } else {
                    propagatedClass = value.substring(0, p);
                    propagatedProp = value.substring(p + 1);
                }
                this.propagationMap.add(propagatedProp, propagatedClass, prop.getName());
            }
            ++i;
        }
        return this.propagationMap;
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = CIMFactory.classname(value);
            } else if ("SUPERCLASS".equals(name)) {
                this.attrSuperClass = CIMFactory.classname(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addClass(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.attrName != null) {
                this.attrName.validateCharacters(includeNames);
            }
            if (this.attrSuperClass != null) {
                this.attrName.validateCharacters(includeNames);
            }
            this.properties.validateCharacters(includeNames);
            this.propertyArrays.validateCharacters(includeNames);
            this.propertyReferences.validateCharacters(includeNames);
            this.methods.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    public String getName() {
        return this.attrName.toDisplayString();
    }

    public final boolean isAssociation() {
        CIMQualifier assocQual = this.getQualifiers().get("ASSOCIATION");
        if (assocQual == null) {
            return false;
        }
        CIMValue value = assocQual.getCIMValue();
        return value == null ? false : value.isTrue();
    }

    public final String getClassname() {
        return this.attrName.toDisplayString();
    }

    public final CIMClassname getCIMClassname() {
        return this.attrName;
    }

    public final String getDisplayName() {
        String value;
        CIMQualifier qual = this.getQualifierByName("DisplayName");
        if (qual != null && (value = qual.getValue()) != null && value.length() != 0) {
            return value;
        }
        return this.attrName.toDisplayString();
    }

    public final void addProperty(CIMProperty aProperty) {
        this.properties.add(aProperty);
    }

    public final void addPropertyArray(CIMPropertyArray aPropertyArray) {
        this.propertyArrays.add(aPropertyArray);
    }

    public final void addPropertyReference(CIMPropertyReference aPropertyReference) {
        this.propertyReferences.add(aPropertyReference);
    }

    public final void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public final void removePropertyArray(String propertyArrayName) {
        this.propertyArrays.remove(propertyArrayName);
    }

    public final void removePropertyReference(String propertyReferenceName) {
        this.propertyReferences.remove(propertyReferenceName);
    }

    public final CIMProperty getPropertyByName(String propertyName) {
        return this.properties.get(propertyName);
    }

    public final CIMPropertyArray getPropertyArrayByName(String propertyArrayName) {
        return this.propertyArrays.get(propertyArrayName);
    }

    public final CIMPropertyReference getPropertyReferenceByName(String propertyReferenceName) {
        return this.propertyReferences.get(propertyReferenceName);
    }

    public final String getPropertyValue(String propertyName) {
        CIMProperty prop = this.getPropertyByName(propertyName);
        return prop == null ? null : prop.getValue();
    }

    public final CIMPropertyList getProperties() {
        return this.properties;
    }

    public final CIMPropertyArrayList getPropertyArrays() {
        return this.propertyArrays;
    }

    public final CIMPropertyReferenceList getPropertyReferences() {
        return this.propertyReferences;
    }

    public final Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public final Iterator getPropertyArrayIterator() {
        return this.propertyArrays.iterator();
    }

    public final Iterator getPropertyReferenceIterator() {
        return this.propertyReferences.iterator();
    }

    public final CIMUniqueList getPropertiesByType(int index) {
        switch (index) {
            case 0: {
                return this.properties;
            }
            case 1: {
                return this.propertyReferences;
            }
            case 2: {
                return this.propertyArrays;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index value: " + index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PropagationMap {
        private final HashMap map = new HashMap();

        PropagationMap() {
        }

        private void add(String propagatedPropName, String propagatedClassName, String weakPropName) {
            PropagationInfo info = new PropagationInfo(propagatedClassName, weakPropName);
            String key = propagatedPropName.toLowerCase();
            info.next = (PropagationInfo)this.map.get(key);
            this.map.put(key, info);
        }

        public PropagationInfo get(String propagatedPropName) {
            return (PropagationInfo)this.map.get(propagatedPropName.toLowerCase());
        }
    }

    public static class PropagationInfo {
        public final String propagatedClassName;
        public final String weakPropName;
        private PropagationInfo next;
        private CIMClassname propCIMClassName;

        PropagationInfo(String propagatedClassName, String weakPropName) {
            this.propagatedClassName = propagatedClassName;
            this.weakPropName = weakPropName;
        }

        public CIMClassname getPropagatedCIMClassName() {
            if (this.propCIMClassName == null && this.propagatedClassName != null) {
                this.propCIMClassName = CIMFactory.classname(this.propagatedClassName);
            }
            return this.propCIMClassName;
        }

        public PropagationInfo next() {
            return this.next;
        }
    }
}

