/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder.examples;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericInputData;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.builder.MappingUtility;
import com.sap.lcr.api.builder.SimpleDeltaBuilder;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Version;
import java.util.List;

public class HostedSystemBuilder
extends SimpleDeltaBuilder {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$examples$HostedSystemBuilder == null ? (class$com$sap$lcr$api$builder$examples$HostedSystemBuilder = HostedSystemBuilder.class$("com.sap.lcr.api.builder.examples.HostedSystemBuilder")) : class$com$sap$lcr$api$builder$examples$HostedSystemBuilder).getName());
    static /* synthetic */ Class class$com$sap$lcr$api$builder$examples$HostedSystemBuilder;

    protected HostedSystemBuilder(CIMOMHandle aCIMClient) {
        super(aCIMClient);
    }

    protected boolean evaluateSpecificAssociationDelta(DeltaElement obj, IDelta delta) throws LcrException {
        DeltaElement hostedSystem = MappingUtility.extractReferencedName(obj, "Dependent");
        if (hostedSystem == null) {
            return false;
        }
        DeltaElement hostingSystem = MappingUtility.extractReferencedName(obj, "Antecedent");
        if (hostingSystem == null) {
            return false;
        }
        DeltaElement serverHostingSystem = this.retrieveObject(hostingSystem);
        if (serverHostingSystem.hasInstance()) {
            List currentHostedSystems = this.listAssociators(serverHostingSystem, CIMNames.C_SAP_HostedApplicationSystem.toDisplayString(), hostedSystem.getMyInstanceName().getClassname());
            if (currentHostedSystems.size() > 0) {
                int i = 0;
                while (i < currentHostedSystems.size()) {
                    DeltaElement nextHostedSystem = (DeltaElement)currentHostedSystems.get(i);
                    if (!nextHostedSystem.equals(hostedSystem)) {
                        delta.processDelta();
                        DeltaElement fullHostedSystem = this.retrieveObject(hostedSystem);
                        this.evaluateRenameDelta(nextHostedSystem, fullHostedSystem, delta);
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected DeltaElement findSpecificOriginalObject(DeltaElement obj) throws LcrException {
        return null;
    }

    protected boolean evaluateSpecificRenameDelta(DeltaElement originalObj, DeltaElement currentObj, IDelta delta) throws LcrException {
        return false;
    }

    protected Logger getLogger() {
        return myLogger;
    }

    public String getSupplierName() {
        return "HostedSystemBuilder";
    }

    public Version getRequiredModelVersion() {
        return new Version(1, 4, 8);
    }

    public void refresh() throws LcrException {
    }

    public boolean accept(IData dataObj) {
        return dataObj instanceof GenericInputData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

