/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder.examples;

import com.sap.lcr.api.builder.DataQueue;
import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.IBuilder;
import com.sap.lcr.api.builder.SynchronousDirector;
import com.sap.lcr.api.builder.examples.ReleaseBuilder;
import com.sap.lcr.api.builder.examples.ReleaseBuilderConstants;
import com.sap.lcr.api.builder.examples.ReleaseBuilderFactory;
import com.sap.lcr.api.builder.examples.ReleaseData;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.URL;

public class DefineReleaseStructure
implements ReleaseBuilderConstants {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$examples$DefineReleaseStructure == null ? (class$com$sap$lcr$api$builder$examples$DefineReleaseStructure = DefineReleaseStructure.class$("com.sap.lcr.api.builder.examples.DefineReleaseStructure")) : class$com$sap$lcr$api$builder$examples$DefineReleaseStructure).getName());
    static /* synthetic */ Class class$com$sap$lcr$api$builder$examples$DefineReleaseStructure;

    public static void main(String[] args) {
        DeltaElement trgSCElem;
        DeltaElement srcSCElem;
        CIMOMClient myCIMClient;
        if (args.length <= 12) {
            System.out.println("Usage: DefineReleaseStructure <host> <port> <user> <pwd> <srcElementTypeID> <srcVendor> <srcName> <srcVersion> <targetElementTypeID> <targetVendor> <targetName> <targetVersion> test/copy");
            return;
        }
        boolean testMode = true;
        if (args[12].equals("copy")) {
            testMode = false;
        }
        String myHost = args[0];
        String myPort = args[1];
        String myUser = args[2];
        String myPwd = args[3];
        try {
            URL myCimOmURL = ClientFactory.newSAPHttpURL(myHost, Integer.parseInt(myPort));
            myCIMClient = ClientFactory.newInstance().createClient(myCimOmURL, myUser, myPwd);
            srcSCElem = new DeltaElement("SAP_SoftwareComponent", ReleaseBuilderConstants.SC_KEYPROP_NAMES, new String[]{args[4], args[5], args[6], args[7]});
            trgSCElem = new DeltaElement("SAP_SoftwareComponent", ReleaseBuilderConstants.SC_KEYPROP_NAMES, new String[]{args[8], args[9], args[10], args[11]});
        }
        catch (CIMClientException cce) {
            System.out.println("Client exception " + cce.getMessage() + " thrown, aborted.");
            cce.printStackTrace();
            return;
        }
        catch (NumberFormatException nfe) {
            System.out.println("Illegal port specified: " + myPort);
            nfe.printStackTrace();
            return;
        }
        catch (ItemConstructionExcp ice) {
            System.out.println("Unable to create software component elements.");
            ice.printStackTrace();
            return;
        }
        SynchronousDirector myDirector = new SynchronousDirector();
        ReleaseBuilderFactory myBuilderFactory = new ReleaseBuilderFactory();
        try {
            myDirector.addCIMClient(myCIMClient);
            myDirector.addBuilders(myBuilderFactory);
            IBuilder[] builders = myDirector.getBuilders(myBuilderFactory);
            int i = 0;
            while (i < builders.length) {
                ((ReleaseBuilder)builders[i]).setTestMode(testMode);
                ++i;
            }
        }
        catch (CIMClientException cce) {
            System.out.println("Unable to setup director.");
            cce.printStackTrace();
            return;
        }
        catch (LcrException lce) {
            System.out.println("Unable to setup director.");
            lce.printStackTrace();
            return;
        }
        DataQueue myQueue = new DataQueue();
        ReleaseData myData = new ReleaseData(srcSCElem, trgSCElem);
        myQueue.add(myData);
        myDirector.setDataQueue(myQueue);
        try {
            myDirector.distributeData();
        }
        catch (LcrException lce) {
            System.out.println("Error when copying the development components, data distribution aborted.");
            lce.printStackTrace();
            return;
        }
        if (!testMode) {
            myLogger.info("DCs copied from SC " + srcSCElem.toDisplayString() + "to SC " + trgSCElem.toDisplayString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

