/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DataQueue;
import com.sap.lcr.api.builder.GenericDirector;
import com.sap.lcr.api.builder.IBuilder;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDataQueue;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.text.MessageFormat;

public class SynchronousDirector
extends GenericDirector {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$SynchronousDirector == null ? (class$com$sap$lcr$api$builder$SynchronousDirector = SynchronousDirector.class$("com.sap.lcr.api.builder.SynchronousDirector")) : class$com$sap$lcr$api$builder$SynchronousDirector).getName());
    private int dataCount = 0;
    static /* synthetic */ Class class$com$sap$lcr$api$builder$SynchronousDirector;

    public SynchronousDirector() {
        this.setDataQueue(new DataQueue());
    }

    public void distributeData() throws LcrException {
        IDataQueue dataQueue = this.getDataQueue();
        if (CIMTraceUtil.traceLevel >= 2) {
            myLogger.info("Starting synchronous data distribution of " + dataQueue.size() + " data elements.");
        }
        while (!dataQueue.isEmpty()) {
            IData nextData = dataQueue.get();
            int i = 0;
            while (i < this.myBuilders.size()) {
                IBuilder nextBuilder = (IBuilder)this.myBuilders.get(i);
                if (nextBuilder.accept(nextData)) {
                    nextBuilder.syncData(nextData);
                    nextBuilder.executeDelta();
                }
                ++i;
            }
            ++this.dataCount;
        }
        if (CIMTraceUtil.traceLevel >= 2) {
            myLogger.info("Synchronous data distribution of " + this.dataCount + " data elements finished successfully.");
        }
    }

    public String printStatus() {
        return MessageFormat.format("{0} data elements synchronized, {1} remaining elements in data queue", new Integer(this.dataCount), new Integer(this.getDataQueue().size()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

