/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericDeltaBuilder;
import com.sap.lcr.api.builder.GenericInputData;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import java.util.List;

public abstract class SimpleDeltaBuilder
extends GenericDeltaBuilder {
    protected SimpleDeltaBuilder(CIMOMHandle aCIMClient) {
        super(aCIMClient);
    }

    public void buildDelta() throws LcrException {
        IData data = this.getCurrentData();
        if (!(data instanceof GenericInputData)) {
            if (CIMTraceUtil.traceLevel >= 4) {
                this.getLogger().fine("Invalid data supplied to buildDelta, class = " + data.getClass().getName());
            }
            return;
        }
        this.processModifications(data);
        this.processDeletions(data);
    }

    private void processModifications(IData data) throws LcrException {
        IDelta delta = this.getCurrentDelta();
        List newData = ((GenericInputData)data).getElements();
        if (newData == null) {
            return;
        }
        int i = 0;
        while (i < newData.size()) {
            Object nextObject = newData.get(i);
            if (!(nextObject instanceof DeltaElement)) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    this.getLogger().fine("Invalid object in data, class = " + nextObject.getClass().getName());
                }
            } else {
                DeltaElement nextElement = (DeltaElement)nextObject;
                CIMInstance nextInstance = nextElement.getMyInstance();
                if (nextInstance == null) {
                    if (CIMTraceUtil.traceLevel >= 4) {
                        this.getLogger().fine("Invalid object in data; no instance defined for " + nextElement.toDisplayString());
                    }
                } else {
                    DeltaElement renameSource = this.findSpecificOriginalObject(nextElement);
                    if (renameSource != null) {
                        if (CIMTraceUtil.traceLevel >= 4) {
                            this.getLogger().fine("Rename triggered for object " + nextElement.toDisplayString() + ", rename source = " + renameSource.toDisplayString());
                        }
                        if (!this.evaluateSpecificRenameDelta(renameSource, nextElement, delta)) {
                            if (CIMTraceUtil.traceLevel >= 4) {
                                this.getLogger().fine("Simple builder: renaming instance " + renameSource.toDisplayString() + " to instance " + nextElement.toDisplayString());
                            }
                            this.evaluateRenameDelta(renameSource, nextElement, delta);
                        }
                    } else if (nextInstance.isAssociation()) {
                        if (CIMTraceUtil.traceLevel >= 4) {
                            this.getLogger().fine("Instance to be synchronized is an association: " + nextElement.toDisplayString());
                        }
                        if (!this.evaluateSpecificAssociationDelta(nextElement, delta)) {
                            if (CIMTraceUtil.traceLevel >= 4) {
                                this.getLogger().fine("Simple builder: synchronizing association instance " + nextElement.toDisplayString());
                            }
                            this.evaluateSyncDelta(nextElement, true, delta);
                        }
                    } else {
                        if (CIMTraceUtil.traceLevel >= 4) {
                            this.getLogger().fine("Simple builder: synchronizing instance " + nextElement.toDisplayString());
                        }
                        this.evaluateSyncDelta(nextElement, true, delta);
                    }
                }
            }
            ++i;
        }
    }

    private void processDeletions(IData data) throws LcrException {
        List delData = ((GenericInputData)data).getDeletions();
        if (delData == null) {
            return;
        }
        IDelta delta = this.getCurrentDelta();
        int i = 0;
        while (i < delData.size()) {
            Object nextObject = delData.get(i);
            if (!(nextObject instanceof DeltaElement)) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    this.getLogger().fine("Invalid object in deletion data, class = " + nextObject.getClass().getName());
                }
            } else {
                DeltaElement nextElement = (DeltaElement)nextObject;
                CIMInstancename nextInstanceName = nextElement.getMyInstanceName();
                if (nextInstanceName == null) {
                    if (CIMTraceUtil.traceLevel >= 4) {
                        this.getLogger().fine("Invalid object in deletion data; no instance name defined.");
                    }
                } else {
                    if (CIMTraceUtil.traceLevel >= 4) {
                        this.getLogger().fine("Simple builder: removing instance " + nextElement.toDisplayString());
                    }
                    this.evaluateDeleteDelta(nextElement, delta);
                }
            }
            ++i;
        }
    }

    protected abstract boolean evaluateSpecificAssociationDelta(DeltaElement var1, IDelta var2) throws LcrException;

    protected abstract DeltaElement findSpecificOriginalObject(DeltaElement var1) throws LcrException;

    protected abstract boolean evaluateSpecificRenameDelta(DeltaElement var1, DeltaElement var2, IDelta var3) throws LcrException;
}

