/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.GenericDelta;
import com.sap.lcr.api.builder.IBuilder;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Version;

public abstract class GenericBuilder
implements IBuilder {
    protected CIMOMHandle myCIMClient = null;
    protected IDelta lastDelta;
    protected IDelta currentDelta;
    protected IData lastData;
    protected IData currentData;
    protected boolean supplierNameSet = false;
    protected boolean syncTimeUpdated = false;

    protected GenericBuilder(CIMOMHandle aCIMClient) {
        this.myCIMClient = aCIMClient;
    }

    public CIMOMHandle getCIMClient() {
        return this.myCIMClient;
    }

    protected abstract Logger getLogger();

    protected abstract void buildDelta() throws LcrException;

    public void syncData(IData syncData) throws LcrException {
        this.lastData = this.currentData;
        this.currentData = syncData;
        if (this.currentDelta == null || this.currentDelta.isProcessed()) {
            this.lastDelta = this.currentDelta;
            this.currentDelta = new GenericDelta(this.myCIMClient);
            if (this.supplierNameSet) {
                ((GenericDelta)this.currentDelta).setMySupplierName(this.getSupplierName());
            }
            if (this.syncTimeUpdated) {
                ((GenericDelta)this.currentDelta).setSyncTimeUpdated(true);
            }
        }
        this.buildDelta();
    }

    public void executeDelta() throws LcrException {
        this.currentDelta.processDelta();
    }

    public IData getCurrentData() {
        return this.currentData;
    }

    public IData getLastData() {
        return this.lastData;
    }

    public IDelta getCurrentDelta() {
        return this.currentDelta;
    }

    public IDelta getLastDelta() {
        return this.lastDelta;
    }

    public boolean isSupplierNameSet() {
        return this.supplierNameSet;
    }

    public boolean isSyncTimeUpdated() {
        return this.syncTimeUpdated;
    }

    public void setSupplierNameSet(boolean b) {
        this.supplierNameSet = b;
    }

    public void setSyncTimeUpdated(boolean b) {
        this.syncTimeUpdated = b;
    }

    public abstract boolean accept(IData var1);

    public abstract void refresh() throws LcrException;

    public abstract Version getRequiredModelVersion();

    public abstract String getSupplierName();
}

