/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDataQueue;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

public class DataQueue
implements IDataQueue {
    LinkedList myFreeElements = new LinkedList();
    LinkedList myLockedElements = new LinkedList();

    public synchronized void add(IData anElement) {
        this.myFreeElements.addFirst(new QueueElement(anElement));
    }

    public synchronized void addUnique(IData anElement) {
        ListIterator iter = this.myFreeElements.listIterator();
        while (iter.hasNext()) {
            QueueElement nextElem = (QueueElement)iter.next();
            if (!nextElem.data.equals(anElement)) continue;
            iter.remove();
        }
        ListIterator iter2 = this.myLockedElements.listIterator();
        while (iter2.hasNext()) {
            QueueElement nextElem = (QueueElement)iter2.next();
            if (!nextElem.data.equals(anElement)) continue;
            iter2.remove();
        }
        this.myFreeElements.addFirst(new QueueElement(anElement));
    }

    public synchronized IData get() {
        if (this.myFreeElements.isEmpty()) {
            return null;
        }
        IData result = ((QueueElement)this.myFreeElements.getLast()).data;
        this.myFreeElements.removeLast();
        return result;
    }

    public synchronized IData pick() {
        QueueElement lastElement = (QueueElement)this.myFreeElements.getLast();
        IData result = lastElement.data;
        this.myLockedElements.addFirst(lastElement);
        this.myFreeElements.removeLast();
        return result;
    }

    public synchronized void acknowledge(IData anElement) {
        ListIterator iter = this.myLockedElements.listIterator(this.myLockedElements.size());
        while (iter.hasPrevious()) {
            QueueElement nextElem = (QueueElement)iter.previous();
            if (!nextElem.data.equals(anElement)) continue;
            iter.remove();
            break;
        }
    }

    public synchronized void free(IData anElement) {
        QueueElement targetElem = null;
        ListIterator iter = this.myLockedElements.listIterator(this.myLockedElements.size());
        while (iter.hasPrevious()) {
            targetElem = (QueueElement)iter.previous();
            if (!targetElem.data.equals(anElement)) continue;
            this.myFreeElements.addLast(targetElem);
            iter.remove();
            break;
        }
    }

    public synchronized boolean contains(IData anElement) {
        return this.myFreeElements.contains(anElement) || this.myLockedElements.contains(anElement);
    }

    public synchronized boolean isFree(IData anElement) {
        return this.myFreeElements.contains(anElement);
    }

    public synchronized int size() {
        return this.myFreeElements.size() + this.myLockedElements.size();
    }

    public synchronized int sizeFree() {
        return this.myFreeElements.size();
    }

    public synchronized int sizeLocked() {
        return this.myLockedElements.size();
    }

    public synchronized boolean isEmpty() {
        return this.myFreeElements.isEmpty();
    }

    public synchronized void clear() {
        this.myFreeElements.clear();
        this.myLockedElements.clear();
    }

    public synchronized void cleanLocks(int minAge) {
        long nowTime = new Date().getTime();
        long minTimeDiff = 1000L * (long)minAge;
        ListIterator iter = this.myLockedElements.listIterator();
        while (iter.hasNext()) {
            QueueElement nextElem = (QueueElement)iter.next();
            long nextTime = nextElem.creationDate.getTime();
            long timeDiff = nowTime - nextTime;
            if (timeDiff < minTimeDiff) continue;
            iter.remove();
        }
    }

    class QueueElement {
        IData data;
        Date creationDate;

        QueueElement(IData anIData) {
            this.data = anIData;
            this.creationDate = new Date();
        }
    }
}

