/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericDeltaBuilder;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.builder.InvalidDataException;
import com.sap.lcr.api.builder.MappingUtility;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AssociatorsDeltaAnalyzer {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$AssociatorsDeltaAnalyzer == null ? (class$com$sap$lcr$api$builder$AssociatorsDeltaAnalyzer = AssociatorsDeltaAnalyzer.class$("com.sap.lcr.api.builder.AssociatorsDeltaAnalyzer")) : class$com$sap$lcr$api$builder$AssociatorsDeltaAnalyzer).getName());
    private GenericDeltaBuilder myCaller;
    private DeltaElement myRoot;
    private String myAssociationClassName;
    private String myRootRole;
    private String myMemberRole;
    private boolean synchronizeRoot = false;
    private boolean synchronizeMembers = true;
    private boolean mergeProperties = true;
    private boolean mergeMembers = true;
    private boolean mergeRoots = true;
    private ArrayList dispensableMembers = new ArrayList();
    private ArrayList dispensable2Members = new ArrayList();
    private ArrayList dispensableRoots = new ArrayList();
    private ArrayList dispensable2Roots = new ArrayList();
    static /* synthetic */ Class class$com$sap$lcr$api$builder$AssociatorsDeltaAnalyzer;

    public AssociatorsDeltaAnalyzer(GenericDeltaBuilder caller, DeltaElement root, String anAssociationClassName, String rootRole, String memberRole) {
        this.myCaller = caller;
        this.myRoot = root;
        this.myAssociationClassName = anAssociationClassName;
        this.myRootRole = rootRole;
        this.myMemberRole = memberRole;
    }

    public void evaluateAssociatorsDelta(Collection newMembers, IDelta delta) throws LcrException {
        DeltaElement serverRootElem = this.myCaller.retrieveObject(this.myRoot);
        if (this.synchronizeRoot || !serverRootElem.hasInstance()) {
            if (CIMTraceUtil.traceLevel >= 6) {
                myLogger.finest("Associators delta: synchronizing root element " + this.myRoot.toDisplayString());
            }
            this.myCaller.evaluateSyncDelta(this.myRoot, this.mergeProperties, delta);
        }
        List serverRootMemberRefs = serverRootElem.hasInstance() ? this.myCaller.listReferences(this.myRoot, this.myAssociationClassName) : new ArrayList();
        ArrayList newMemberAndRefElems = new ArrayList();
        boolean[] newMemberExists = new boolean[serverRootMemberRefs.size()];
        if (CIMTraceUtil.traceLevel >= 6) {
            myLogger.finest("Associators delta: synchronizing members of root element " + this.myRoot.toDisplayString());
        }
        this.evaluateMemberSyncState(newMembers, serverRootMemberRefs, newMemberAndRefElems, newMemberExists);
        if (!this.mergeMembers) {
            if (CIMTraceUtil.traceLevel >= 6) {
                myLogger.finest("Associators delta: removing references to old members.");
            }
            this.removeOldMemberRefs(serverRootMemberRefs, newMemberExists, delta);
        }
        this.evaluateNewMemberDelta(newMemberAndRefElems, delta);
    }

    private void evaluateNewMemberDelta(ArrayList newMemberAndRefElems, IDelta delta) throws LcrException {
        int i = 0;
        while (i < newMemberAndRefElems.size()) {
            DeltaElement[] nextElemTriple = (DeltaElement[])newMemberAndRefElems.get(i);
            DeltaElement nextServerMemberElem = this.myCaller.retrieveObject(nextElemTriple[0]);
            if (this.synchronizeMembers) {
                if (CIMTraceUtil.traceLevel >= 6) {
                    myLogger.finest("Associators delta: synchronizing member element " + nextElemTriple[0].toDisplayString());
                }
                if (!nextServerMemberElem.hasInstance()) {
                    this.myCaller.evaluateCreateDelta(nextElemTriple[0], delta);
                } else {
                    this.myCaller.evaluateModifyDelta(nextElemTriple[0], nextServerMemberElem, this.mergeProperties, delta);
                }
            }
            if (!this.mergeRoots && nextServerMemberElem.hasInstance()) {
                this.evaluateRootSyncDelta(nextElemTriple, nextServerMemberElem, delta);
            }
            if (CIMTraceUtil.traceLevel >= 6) {
                myLogger.finest("Associators delta: synchronizing member association " + nextElemTriple[1].toDisplayString());
            }
            if (nextElemTriple[2] == null) {
                this.myCaller.evaluateCreateDelta(nextElemTriple[1], delta);
            } else {
                this.myCaller.evaluateModifyDelta(nextElemTriple[1], nextElemTriple[2], this.mergeProperties, delta);
            }
            ++i;
        }
    }

    private void evaluateRootSyncDelta(DeltaElement[] nextElemTriple, DeltaElement nextServerMemberElem, IDelta delta) throws LcrException {
        List serverMemberRefs = this.myCaller.listReferences(nextElemTriple[0], this.myAssociationClassName);
        int j = 0;
        while (j < serverMemberRefs.size()) {
            DeltaElement nextServerMemberRefElem = (DeltaElement)serverMemberRefs.get(j);
            if (!nextServerMemberRefElem.getMyInstanceName().equals(nextElemTriple[1].getMyInstanceName())) {
                if (CIMTraceUtil.traceLevel >= 5) {
                    myLogger.finer("Associators delta: removing another root association " + nextServerMemberRefElem.toDisplayString());
                }
                this.myCaller.evaluateDeleteDelta(nextServerMemberRefElem, delta);
                DeltaElement nextServerRootElem = MappingUtility.extractReferencedName(nextServerMemberRefElem, this.myRootRole);
                List nextServerRootRefElems = this.myCaller.listReferences(nextServerMemberElem, null);
                if (nextServerRootRefElems.size() > 1) {
                    this.dispensable2Roots.add(nextServerRootElem);
                } else {
                    this.dispensableRoots.add(nextServerRootElem);
                }
            }
            ++j;
        }
    }

    private void evaluateMemberSyncState(Collection newMembers, List serverRootMemberRefs, ArrayList newMemberAndRefElems, boolean[] newMemberExists) throws LcrException {
        int foundOldMembers = 0;
        Iterator newMemberIterator = newMembers.iterator();
        while (newMemberIterator.hasNext()) {
            DeltaElement nextNewMemberRefElem;
            DeltaElement nextNewMemberElem = (DeltaElement)newMemberIterator.next();
            try {
                nextNewMemberRefElem = MappingUtility.createDeltaElement(this.myAssociationClassName, this.myRoot, this.myRootRole, nextNewMemberElem, this.myMemberRole);
            }
            catch (InvalidDataException ivde) {
                if (CIMTraceUtil.traceLevel < 4) continue;
                myLogger.fine("Associators delta: invalid data found for potential member " + nextNewMemberElem.toDisplayString(), ivde);
                continue;
            }
            DeltaElement correspondingServerMemberRefElem = null;
            int i = 0;
            while (i < serverRootMemberRefs.size()) {
                DeltaElement nextServerRootMemberRefElem = (DeltaElement)serverRootMemberRefs.get(i);
                if (nextServerRootMemberRefElem.getMyInstanceName().equals(nextNewMemberRefElem.getMyInstanceName())) {
                    correspondingServerMemberRefElem = nextServerRootMemberRefElem;
                    if (!newMemberExists[i]) {
                        ++foundOldMembers;
                    }
                    newMemberExists[i] = true;
                    break;
                }
                ++i;
            }
            newMemberAndRefElems.add(new DeltaElement[]{nextNewMemberElem, nextNewMemberRefElem, correspondingServerMemberRefElem});
        }
        if (CIMTraceUtil.traceLevel >= 6) {
            myLogger.finest("Associators delta: " + newMemberAndRefElems.size() + " new members, " + serverRootMemberRefs.size() + " old members, " + foundOldMembers + " old members with new counterpart.");
        }
    }

    private void removeOldMemberRefs(List serverRootMemberRefs, boolean[] newMemberExists, IDelta delta) throws LcrException {
        int i = 0;
        while (i < serverRootMemberRefs.size()) {
            if (!newMemberExists[i]) {
                DeltaElement nextServerRootMemberRef = (DeltaElement)serverRootMemberRefs.get(i);
                if (CIMTraceUtil.traceLevel >= 5) {
                    myLogger.finer("Associators delta: removing old member association " + nextServerRootMemberRef.toDisplayString());
                }
                this.myCaller.evaluateDeleteDelta(nextServerRootMemberRef, delta);
                DeltaElement nextServerMemberElem = MappingUtility.extractReferencedName(nextServerRootMemberRef, this.myMemberRole);
                List nextServerMemberRefElems = this.myCaller.listReferences(nextServerMemberElem, null);
                if (nextServerMemberRefElems.size() > 1) {
                    this.dispensable2Members.add(nextServerMemberElem);
                } else {
                    this.dispensableMembers.add(nextServerMemberElem);
                }
            }
            ++i;
        }
    }

    public void evaluateMembersCleanup(boolean removeAll, IDelta delta) throws LcrException {
        int i = 0;
        while (i < this.dispensableMembers.size()) {
            DeltaElement nextElem = (DeltaElement)this.dispensableMembers.get(i);
            if (CIMTraceUtil.traceLevel >= 5) {
                myLogger.finer("Associators delta: removing old member " + nextElem.toDisplayString());
            }
            this.myCaller.evaluateDeleteDelta(nextElem, delta);
            ++i;
        }
        if (removeAll) {
            int i2 = 0;
            while (i2 < this.dispensable2Members.size()) {
                DeltaElement nextElem = (DeltaElement)this.dispensable2Members.get(i2);
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Associators delta: removing old member " + nextElem.toDisplayString());
                }
                this.myCaller.evaluateDeleteDelta(nextElem, delta);
                ++i2;
            }
        }
    }

    public void evaluateRootsCleanup(boolean removeAll, IDelta delta) throws LcrException {
        int i = 0;
        while (i < this.dispensableRoots.size()) {
            DeltaElement nextElem = (DeltaElement)this.dispensableRoots.get(i);
            if (CIMTraceUtil.traceLevel >= 5) {
                myLogger.finer("Associators delta: removing other root " + nextElem.toDisplayString());
            }
            this.myCaller.evaluateDeleteDelta(nextElem, delta);
            ++i;
        }
        if (removeAll) {
            int i2 = 0;
            while (i2 < this.dispensable2Roots.size()) {
                DeltaElement nextElem = (DeltaElement)this.dispensable2Roots.get(i2);
                if (CIMTraceUtil.traceLevel >= 5) {
                    myLogger.finer("Associators delta: removing other root " + nextElem.toDisplayString());
                }
                this.myCaller.evaluateDeleteDelta(nextElem, delta);
                ++i2;
            }
        }
    }

    public void evaluateAssociatorsCleanup(List dispensableInstances, boolean removeAnyway, IDelta delta) throws LcrException {
        int i = 0;
        while (i < dispensableInstances.size()) {
            List nextRefElems;
            DeltaElement serverDispensableElem;
            DeltaElement nextElem = (DeltaElement)dispensableInstances.get(i);
            if (removeAnyway || (serverDispensableElem = this.myCaller.retrieveObject(nextElem)).hasInstance() && (nextRefElems = this.myCaller.listReferences(nextElem, null)).size() <= 0) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Associators delta: removing dispensable instance " + nextElem.toDisplayString());
                }
                this.myCaller.evaluateDeleteDelta(nextElem, delta);
            }
            ++i;
        }
    }

    public void evaluateAssociatorsCleanup(String dispensableClass, boolean removeAnyway, IDelta delta) throws LcrException {
        List candidates = this.myCaller.listObjects(dispensableClass);
        this.evaluateAssociatorsCleanup(candidates, removeAnyway, delta);
    }

    public boolean isMergeMembers() {
        return this.mergeMembers;
    }

    public void setMergeMembers(boolean b) {
        this.mergeMembers = b;
    }

    public boolean isMergeRoots() {
        return this.mergeRoots;
    }

    public void setMergeRoots(boolean b) {
        this.mergeRoots = b;
    }

    public boolean isMergeProperties() {
        return this.mergeProperties;
    }

    public void setMergeProperties(boolean b) {
        this.mergeProperties = b;
    }

    public boolean isSynchronizeMembers() {
        return this.synchronizeMembers;
    }

    public void setSynchronizeMembers(boolean b) {
        this.synchronizeMembers = b;
    }

    public boolean isSynchronizeRoot() {
        return this.synchronizeRoot;
    }

    public void setSynchronizeRoot(boolean b) {
        this.synchronizeRoot = b;
    }

    public List getDispensableMembers() {
        return this.dispensableMembers;
    }

    public List getDispensableRoots() {
        return this.dispensableRoots;
    }

    public List getDispensableButUsedMembers() {
        return this.dispensable2Members;
    }

    public List getDispensableButUsedRoots() {
        return this.dispensable2Roots;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

