/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.PersistenceFSCache;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class GenerateJMI {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$GenerateJMI == null ? (class$com$sap$ip$mmr$tools$GenerateJMI = GenerateJMI.class$("com.sap.ip.mmr.tools.GenerateJMI")) : class$com$sap$ip$mmr$tools$GenerateJMI);
    private String sourcepath;
    private String destpath;
    private String tmppath;
    private boolean verbose = false;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$GenerateJMI;

    public static void main(String[] args) {
        GenerateJMI gen = new GenerateJMI();
        int nargs = 0;
        for (int i = 0; i < args.length; ++i) {
            String value;
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                GenerateJMI.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            ++nargs;
            if (param.compareToIgnoreCase("srcpath") == 0) {
                value = XMIImport.getValue(args[i]);
                gen.setSourcepath(value);
                continue;
            }
            if (param.compareToIgnoreCase("dstpath") == 0) {
                value = XMIImport.getValue(args[i]);
                gen.setDestpath(value);
                continue;
            }
            if (param.compareToIgnoreCase("tmppath") == 0) {
                value = XMIImport.getValue(args[i]);
                gen.setTmppath(value);
                continue;
            }
            if (param.compareToIgnoreCase("verbose") != 0) continue;
            gen.setVerbose(true);
        }
        gen.execute();
    }

    public static void writeUsage() {
        System.err.println("Usage: GenerateJMI [-options]");
        System.err.println("where options include:");
        System.err.println("    -srcpath=<source directory with XMI files or Jar file>");
        System.err.println("    -dstpath=<destination directory for Repository>");
        System.err.println("    -tmppath=<temporary directory for Repository>");
        System.err.println("    -verbose");
    }

    public void execute() {
        if (this.sourcepath == null && this.destpath == null) {
            GenerateJMI.writeUsage();
        }
        if (this.sourcepath == null) {
            System.err.println("[GenerateJMI] sourcepath not specified");
            return;
        }
        if (this.destpath == null) {
            System.err.println("[GenerateJMI] destpath not specified; using user temp instead");
        }
        this.connectAndGenerate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectAndGenerate() {
        File file = new File(this.getSourcepath());
        if (!file.exists()) {
            System.out.println("[GenerateJMI] The source file/path doesn't exist: " + this.getSourcepath());
            return;
        }
        try {
            Connection cx;
            Workspace workspace;
            block31: {
                LocalTransaction lt;
                block29: {
                    ConnectionSpec cxs = new ConnectionSpec();
                    workspace = new Workspace("ANT");
                    if (file.isDirectory()) {
                        workspace.setPath(file.getAbsolutePath());
                    } else {
                        workspace.setPath(this.destpath);
                    }
                    cxs.getWorkspacesM1().add(workspace);
                    cxs.getWorkspacesM2().add(workspace);
                    Log log = Utilities.getUtilities().getConsoleLog();
                    location.addLog(log);
                    if (this.verbose) {
                        log.setEffectiveSeverity(300);
                        location.setEffectiveSeverity(300);
                    } else {
                        log.setEffectiveSeverity(400);
                        location.setEffectiveSeverity(400);
                    }
                    location.infoT("Connecting Model Repository ...");
                    cxs.setLog(log);
                    if (this.getTmppath() != null) {
                        cxs.getProperties().put("tempDir", this.getTmppath());
                    }
                    cxs.getProperties().put("MMR_USE_CACHE", Boolean.FALSE);
                    ConnectionFactory cxf = new ConnectionFactory();
                    cx = null;
                    cx = cxf.getConnection(cxs);
                    ModelPackage refPackage = cx.getTopLevelPackageM2();
                    lt = cx.getLocalTransaction();
                    try {
                        try {
                            lt.begin();
                            if (!file.isDirectory()) {
                                try {
                                    if (this.verbose) {
                                        location.infoT("Reading XMI file: " + this.getSourcepath() + " ...");
                                    }
                                    cx.read(this.getSourcepath(), (RefPackage)refPackage);
                                }
                                catch (IOException e) {
                                    Repository.category.errorT(location, e.toString());
                                    Object var11_14 = null;
                                    if (this.verbose) {
                                        location.infoT("Commit ...");
                                    }
                                    lt.commit();
                                    if (this.verbose) {
                                        location.infoT("Generate JMI sources ...");
                                    }
                                    String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                                    HashMap<String, String> p = new HashMap<String, String>();
                                    p.put("srcpath", this.getSourcepath());
                                    p.put("dstpath", this.getDestpath());
                                    p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                                    cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                                    return;
                                }
                                catch (MalformedXMIException e) {
                                    Repository.category.errorT(location, e.toString());
                                    Object var11_15 = null;
                                    if (this.verbose) {
                                        location.infoT("Commit ...");
                                    }
                                    lt.commit();
                                    if (this.verbose) {
                                        location.infoT("Generate JMI sources ...");
                                    }
                                    String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                                    HashMap<String, String> p = new HashMap<String, String>();
                                    p.put("srcpath", this.getSourcepath());
                                    p.put("dstpath", this.getDestpath());
                                    p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                                    cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                                    return;
                                }
                            }
                            Object var11_16 = null;
                            if (!this.verbose) break block29;
                        }
                        catch (Exception e) {
                            Repository.category.errorT(location, e.toString());
                            Object var11_17 = null;
                            if (this.verbose) {
                                location.infoT("Commit ...");
                            }
                            lt.commit();
                            if (this.verbose) {
                                location.infoT("Generate JMI sources ...");
                            }
                            String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                            HashMap<String, String> p = new HashMap<String, String>();
                            p.put("srcpath", this.getSourcepath());
                            p.put("dstpath", this.getDestpath());
                            p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                            cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_18 = null;
                        if (this.verbose) {
                            location.infoT("Commit ...");
                        }
                        lt.commit();
                        if (this.verbose) {
                            location.infoT("Generate JMI sources ...");
                        }
                        String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                        HashMap<String, String> p = new HashMap<String, String>();
                        p.put("srcpath", this.getSourcepath());
                        p.put("dstpath", this.getDestpath());
                        p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                        cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                        throw throwable;
                    }
                    location.infoT("Commit ...");
                }
                lt.commit();
                if (this.verbose) {
                    location.infoT("Generate JMI sources ...");
                }
                String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("srcpath", this.getSourcepath());
                p.put("dstpath", this.getDestpath());
                p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
            }
            if (this.verbose) {
                location.infoT("Close connection to Model Repository ...");
            }
            cx.close();
            if (this.getTmppath() != null) {
                String dir = this.getTmppath() + '/' + "MMRCache" + '/' + PersistenceFSCache.getHashCodeFromWorkspace(workspace);
                this.copyIndexFiles(dir + "/MMR_M2", this.getDestpath() + "/MMR_M2");
                this.copyIndexFiles(dir + "/MMR_M1", this.getDestpath() + "/MMR_M1");
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        if (this.verbose) {
            location.infoT("done.");
        }
    }

    private void copyIndexFiles(String pathS, String pathT) {
        if (pathS == null || pathT == null) {
            return;
        }
        File fs = new File(pathS);
        if (!fs.exists() || !fs.isDirectory()) {
            return;
        }
        File ft = new File(pathT);
        if (!ft.exists() || !ft.isDirectory()) {
            return;
        }
        File[] files = fs.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String ps = files[i].getAbsolutePath();
            String pt = ft.getAbsolutePath() + '/' + files[i].getName();
            byte[] bytes = RepositoryServer.getRepositoryFS().readFileContent(ps);
            RepositoryServer.getRepositoryFS().writeBinary(pt, bytes);
        }
    }

    public String getDestpath() {
        return this.destpath;
    }

    public String getSourcepath() {
        return this.sourcepath;
    }

    public void setDestpath(String destpath) {
        this.destpath = destpath;
    }

    public void setSourcepath(String sourcepath) {
        this.sourcepath = sourcepath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getTmppath() {
        return this.tmppath;
    }

    public void setTmppath(String string) {
        this.tmppath = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

