/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ILocalTransaction;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.FilterTypes;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofPackage;
import javax.resource.ResourceException;

public class DisplayPackageHierarchy {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$DisplayPackageHierarchy == null ? (class$com$sap$ip$mmr$tools$DisplayPackageHierarchy = DisplayPackageHierarchy.class$("com.sap.ip.mmr.tools.DisplayPackageHierarchy")) : class$com$sap$ip$mmr$tools$DisplayPackageHierarchy);
    private IConnection cx;
    private MofPackage rootPackage;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$DisplayPackageHierarchy;

    public DisplayPackageHierarchy(String path) {
        ConnectionSpec cxs = new ConnectionSpec();
        Log log = Utilities.getUtilities().getConsoleLog();
        cxs.setLog(log);
        ConnectionFactory cxf = new ConnectionFactory();
        try {
            this.cx = cxf.getConnection(cxs);
            if (path == null) {
                cxs.getWorkspacesM2().addAll(this.cx.getWorkspacesAvailableM2());
            } else {
                Workspace w = new Workspace("directory");
                w.setPath(path);
                cxs.getWorkspacesM2().add(w);
                RepositoryServer.getRepositoryServer().registerWorkspace(w, 2);
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        try {
            this.rootPackage = this.cx.getMofPackageRootM2();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    public void close() {
        if (this.cx != null) {
            try {
                this.cx.close();
            }
            catch (ResourceException e) {
                Repository.category.errorT(location, e.toString());
            }
        }
    }

    public static void main(String[] args) {
        String path = null;
        int depth = 3;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                DisplayPackageHierarchy.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            String value = XMIImport.getValue(args[i]);
            if (param == null) {
                DisplayPackageHierarchy.writeUsage();
                return;
            }
            if (param.compareToIgnoreCase("depth") == 0) {
                depth = Integer.parseInt(value);
                continue;
            }
            if (param.compareToIgnoreCase("path") != 0) continue;
            path = value;
        }
        DisplayPackageHierarchy packageHierarchy = new DisplayPackageHierarchy(path);
        packageHierarchy.getPackageHierarchy(depth);
        packageHierarchy.close();
    }

    public static void writeUsage() {
        System.err.println("Usage: DisplayPackageHierarchy [-options]");
        System.err.println("where options include:");
        System.err.println("    -dbType=[no]");
        System.err.println("    -depth=[1|2|...]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPackageHierarchy(int depth) {
        try {
            ILocalTransaction lt = (ILocalTransaction)this.cx.getLocalTransaction();
            try {
                lt.begin();
                this.readChildren(depth);
            }
            finally {
                lt.commit();
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    private void readChildren(int depth) {
        this.readChildrenRec(null, 0, depth);
    }

    private void readChildrenRec(ModelElement modelElement, int level, int depth) {
        if (level >= depth) {
            System.out.println(this.getSpace(level * 2) + "...");
            return;
        }
        Collection col = this.getChildrenOfModelElement(modelElement, 1);
        ArrayList list = new ArrayList(col);
        if (list.size() > 0) {
            Collections.sort(list, new ModelElementImpl.ModelElementComparatorName());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                int nSpace;
                ModelElement me = (ModelElement)iter.next();
                String txt = me.getName();
                if (me.getContainer() == null || me.getContainer().equals(this.rootPackage)) {
                    txt = Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName());
                }
                if ((nSpace = 60 - level * 2 - txt.length()) < 1) {
                    nSpace = 1;
                }
                System.out.println(this.getSpace(level * 2) + txt + this.getSpace(nSpace) + "[" + me.refMofId() + "]");
                if (!(me instanceof MofPackage)) continue;
                this.readChildrenRec(me, level + 1, depth);
            }
        }
    }

    private String getSpace(int length) {
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private Collection getChildrenOfModelElement(ModelElement modelElement, int depth) {
        List list = null;
        try {
            ArrayList<ModelElement> elementSearch = null;
            if (modelElement != null) {
                elementSearch = new ArrayList<ModelElement>(1);
                elementSearch.add(modelElement);
            }
            FilterTypes filterTypes = new FilterTypes();
            filterTypes.add("Model.Class");
            filterTypes.add("Model.Package");
            filterTypes.add("Model.Association");
            list = this.cx.collectM2(elementSearch, "Contains", filterTypes, depth, true, null);
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

