/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.BehavioralFeatureImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Constraint;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofException;
import javax.jmi.model.Operation;
import javax.jmi.model.Parameter;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;

public class OperationImpl
extends BehavioralFeatureImpl
implements Operation {
    static final long serialVersionUID = -3204929500317836893L;
    public static final String VISIBILITY = "visibility";
    public static final String SCOPE = "scope";
    public static final String ISQUERY = "isQuery";
    public static final String EXCEPTIONS = "exceptions";
    private boolean query = false;
    private VisibilityKind visibility = VisibilityKindEnum.PUBLIC_VIS;
    private ScopeKind scope = ScopeKindEnum.INSTANCE_LEVEL;

    public OperationImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public OperationImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public OperationImpl(IRepository repository, String name, String annotation, ScopeKind scope, VisibilityKind visibility, boolean isQuery) {
        super(repository, name);
        this.initialize();
        this.setAnnotation(annotation);
        this.setScope(scope);
        this.setVisibility(visibility);
        this.setQuery(isQuery);
    }

    private final void initialize() {
        this.visibility = VisibilityKindEnum.PUBLIC_VIS;
        this.scope = ScopeKindEnum.INSTANCE_LEVEL;
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof OperationImpl) {
            OperationImpl o = (OperationImpl)modelElement;
            this.setVisibility(o.getVisibility());
            this.setScope(o.getScope());
            this.setQuery(o.isQuery());
        }
    }

    public boolean isQuery() {
        return this.query;
    }

    public final void setQuery(boolean newValue) {
        if (this.query != newValue) {
            this.query = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public List getExceptions() {
        return this.getModelPackage().getCanRaise().getExcept((Operation)this);
    }

    public ScopeKind getScope() {
        return this.scope;
    }

    public final void setScope(ScopeKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.scope == null || !this.scope.equals(newValue)) {
            this.scope = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(VisibilityKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.visibility == null || !this.visibility.equals(newValue)) {
            this.visibility = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VISIBILITY) == 0) {
            if (value instanceof String) {
                this.setVisibility(OperationImpl.stringToVisibility((String)value));
            } else {
                this.setVisibility((VisibilityKind)value);
            }
        } else if (featureName.compareTo(SCOPE) == 0) {
            if (value instanceof String) {
                this.setScope(OperationImpl.stringToScope((String)value));
            } else {
                this.setScope((ScopeKind)value);
            }
        } else if (featureName.compareTo(ISQUERY) == 0) {
            if (value instanceof String) {
                this.setQuery(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setQuery((Boolean)value);
            }
        } else if (featureName.compareTo(ISQUERY) == 0) {
            this.getExceptions().add(value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(VISIBILITY) == 0) {
                o = this.getVisibility();
            } else if (featureName.compareTo(SCOPE) == 0) {
                o = this.getScope();
            } else if (featureName.compareTo(ISQUERY) == 0) {
                o = new Boolean(this.isQuery());
            } else if (featureName.compareTo(EXCEPTIONS) == 0) {
                o = this.getExceptions();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (me instanceof Parameter || me instanceof Constraint || me instanceof Tag) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_28", new Object[]{this}));
        }
        Parameter pr = null;
        iter = this.getContents().iterator();
        while (iter.hasNext()) {
            Parameter p;
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof Parameter) || !(p = (Parameter)me).getDirection().equals(DirectionKindEnum.RETURN_DIR)) continue;
            if (pr != null) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_29", new Object[]{this}));
            }
            pr = p;
        }
        iter = this.getExceptions().iterator();
        while (iter.hasNext()) {
            MofException excp = (MofException)iter.next();
            if (this.isVisible((ModelElement)excp)) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_30", new Object[]{this}));
        }
        return col;
    }
}

