/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jmi.model.Constant;
import javax.jmi.model.Constraint;
import javax.jmi.model.EvaluationKind;
import javax.jmi.model.EvaluationKindEnum;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Tag;

public class ConstraintImpl
extends ModelElementImpl
implements Constraint {
    static final long serialVersionUID = -7003270428946703230L;
    public static final String EXPRESSION = "expression";
    public static final String LANGUAGE = "language";
    public static final String EVALUATIONPOLICY = "evaluationPolicy";
    public static final String CONSTRAINEDELEMENTS = "constrainedElements";
    private String expression = "";
    private String language = Locale.getDefault().getLanguage();
    private EvaluationKind evaluationPolicy = EvaluationKindEnum.IMMEDIATE;

    public ConstraintImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public ConstraintImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public ConstraintImpl(IRepository repository, String name, String annotation, String expression, String language, EvaluationKind evaluationPolicy) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setExpression(expression);
        this.setLanguage(language);
        this.setEvaluationPolicy(evaluationPolicy);
    }

    private void initialize() {
        this.expression = "";
        this.language = "en";
        this.evaluationPolicy = EvaluationKindEnum.IMMEDIATE;
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof ConstraintImpl) {
            ConstraintImpl c = (ConstraintImpl)modelElement;
            this.setEvaluationPolicy(c.getEvaluationPolicy());
            this.setExpression(c.expression);
            this.setLanguage(c.language);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public final void setExpression(String newValue) {
        if (newValue == null) {
            return;
        }
        if (!this.expression.equals(newValue)) {
            this.expression = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public final void setLanguage(String newValue) {
        if (newValue == null) {
            return;
        }
        if (this.language.compareTo(newValue) != 0) {
            this.language = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public EvaluationKind getEvaluationPolicy() {
        return this.evaluationPolicy;
    }

    public final void setEvaluationPolicy(EvaluationKind newValue) {
        if (newValue == null) {
            return;
        }
        if (!this.evaluationPolicy.equals(newValue)) {
            this.evaluationPolicy = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public Collection getConstrainedElements() {
        return this.getModelPackage().getConstrains().getConstrainedElement((Constraint)this);
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(EXPRESSION) == 0) {
            this.setExpression((String)value);
        } else if (featureName.compareTo(LANGUAGE) == 0) {
            this.setLanguage(this.language);
        } else if (featureName.compareTo(EVALUATIONPOLICY) == 0) {
            this.setEvaluationPolicy((EvaluationKind)value);
        } else if (featureName.compareTo(CONSTRAINEDELEMENTS) == 0) {
            this.getConstrainedElements().add(value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(EXPRESSION) == 0) {
                o = this.getExpression();
            } else if (featureName.compareTo(LANGUAGE) == 0) {
                o = this.getLanguage();
            } else if (featureName.compareTo(EVALUATIONPOLICY) == 0) {
                o = this.getEvaluationPolicy();
            } else if (featureName.compareTo(CONSTRAINEDELEMENTS) == 0) {
                o = this.getConstrainedElements();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        Collection c = this.getConstrainedElements();
        if (c != null) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof Constraint) && !(me instanceof Tag) && !(me instanceof Import) && !(me instanceof Constant)) continue;
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_50", new Object[]{this}));
            }
        }
        if (c != null) {
            List cns = this.getContainer().getContents();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (cns.contains(me)) continue;
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_51", new Object[]{this}));
            }
        }
        return col;
    }
}

