/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.m2layer.model.DataTypeImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl;
import java.util.Collection;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKind;

public class CollectionTypeImpl
extends DataTypeImpl
implements CollectionType {
    static final long serialVersionUID = -4603949845937867365L;
    public static final String TYPE = "type";
    public static final String MULTIPLICITY = "multiplicity";
    private MultiplicityType multiplicity = new MultiplicityTypeImpl();

    public CollectionTypeImpl(IRepository repository) {
        super(repository);
    }

    public CollectionTypeImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public CollectionTypeImpl(IRepository repository, String name, String annotation, boolean isRoot, boolean isLeaf, boolean isAbstract, VisibilityKind visibility, MultiplicityType multiplicity) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setRoot(isRoot);
        this.setLeaf(isLeaf);
        this.setAbstract(isAbstract);
        this.setVisibility(visibility);
        this.setMultiplicity(multiplicity);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof CollectionTypeImpl) {
            CollectionTypeImpl ct = (CollectionTypeImpl)modelElement;
            this.setMultiplicity(ct.getMultiplicity());
        }
    }

    public MultiplicityType getMultiplicity() {
        return this.multiplicity;
    }

    public final void setMultiplicity(MultiplicityType newValue) {
        if (newValue == null) {
            return;
        }
        if (this.multiplicity == null || !this.multiplicity.equals(newValue)) {
            this.multiplicity = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public Classifier getType() {
        return this.getModelPackage().getIsOfType().getType((TypedElement)this);
    }

    public void setType(Classifier newValue) {
        this.getModelPackage().getIsOfType().add(newValue, (TypedElement)this);
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(TYPE) == 0) {
            this.setType((Classifier)value);
        } else if (featureName.compareTo(MULTIPLICITY) == 0) {
            this.setMultiplicity((MultiplicityType)value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(TYPE) == 0) {
                o = this.getType();
            } else if (featureName.compareTo(MULTIPLICITY) == 0) {
                o = this.getMultiplicity();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        col = this.checkMultipliticy(col, this.getMultiplicity());
        return col;
    }
}

