/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.CodeContainer;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorPackage {
    public static String getJavaInterfaceName(MofPackage mofPackage) {
        return Generator.getJMIIdentifier((ModelElement)mofPackage) + "Package";
    }

    public static String getJavaInterfaceNameQualified(MofPackage mofPackage) {
        return Generator.getJMIIdentifierQualified((Namespace)mofPackage).toLowerCase() + '.' + Generator.getJMIIdentifier((ModelElement)mofPackage) + "Package";
    }

    public static String getJavaClassName(MofPackage mofPackage) {
        String str = GeneratorPackage.getJavaInterfaceName(mofPackage) + "Impl";
        return str;
    }

    public static String getJavaClassNameQualified(MofPackage mofPackage) {
        String str = GeneratorPackage.getJavaInterfaceNameQualified(mofPackage) + "Impl";
        return str;
    }

    public JavaSource generateTemplate(MofPackage mofPackage, boolean noJavaDocs, boolean generateInterfaces) {
        ModelElement me;
        StringBuffer code = new StringBuffer(1000);
        JavaSource source = null;
        String javaInterfaceName = GeneratorPackage.getJavaInterfaceName(mofPackage);
        String javaInterfaceNameQualified = GeneratorPackage.getJavaInterfaceNameQualified(mofPackage);
        String javaClassName = GeneratorPackage.getJavaClassName(mofPackage);
        String javaClassNameQualified = GeneratorPackage.getJavaClassNameQualified(mofPackage);
        Generator.generatePackageStatement(code, (Namespace)mofPackage);
        Generator.generateDefaultIncludes(code);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)mofPackage);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (generateInterfaces) {
            code.append(" extends ");
            List superTypes = mofPackage.getSupertypes();
            if (superTypes == null || superTypes.size() < 1) {
                code.append("javax.jmi.reflect.RefPackage ");
            } else {
                Iterator iter = superTypes.iterator();
                while (iter.hasNext()) {
                    MofPackage mp = (MofPackage)iter.next();
                    code.append(GeneratorPackage.getJavaInterfaceNameQualified(mp));
                    if (!iter.hasNext()) continue;
                    code.append(", ");
                }
            }
        } else {
            code.append(" implements com.sap.ip.mmr.m1layer.IMMRObject, ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        List contents = Generator.getAllContent((ModelElement)mofPackage);
        if (contents == null || contents.size() < 1) {
            return source;
        }
        if (!generateInterfaces) {
            Generator.generateTemplateRefPackageDecl(code, mofPackage, javaClassName);
        }
        LinkedList<String> listNames = new LinkedList<String>();
        code.append("// each imported package where:");
        code.append(Utilities.SystemLineSeparator);
        code.append("//   isClustered and");
        code.append(Utilities.SystemLineSeparator);
        code.append("//   Import.visibility == public_vis and");
        code.append(Utilities.SystemLineSeparator);
        code.append("//   importedNamespace.visibility == public_vis");
        code.append(Utilities.SystemLineSeparator);
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Import)) continue;
            Import mofImport = (Import)me;
            MofPackage importedNamespace = (MofPackage)mofImport.getImportedNamespace();
            if (!mofImport.isClustered() || !mofImport.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) || !importedNamespace.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
            listNames.add(Generator.getJMIIdentifierQualified(mofImport.getImportedNamespace()));
            String packageNameQualified = GeneratorPackage.getJavaInterfaceNameQualified((MofPackage)mofImport.getImportedNamespace());
            String accessorName = Generator.getJMIIdentifier((ModelElement)mofImport);
            this.generatePackageTemplateClusteredPackage(code, (MofPackage)mofImport.getImportedNamespace(), packageNameQualified, accessorName, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        listNames.clear();
        code.append("// each contained package where visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            MofPackage mp;
            me = (ModelElement)iter.next();
            if (!(me instanceof MofPackage) || !(mp = (MofPackage)me).getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) continue;
            listNames.add(mp.getName());
            String packageNameQualified = GeneratorPackage.getJavaInterfaceNameQualified(mp);
            String accessorName = Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)mp));
            this.generatePackageTemplate(code, mp, packageNameQualified, accessorName, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        listNames.clear();
        code.append("// each directly contained class with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof MofClass)) continue;
            this.generateClassTemplate(code, (MofClass)me, generateInterfaces);
            listNames.add(Generator.getJMIIdentifier(me));
        }
        code.append(Utilities.SystemLineSeparator);
        listNames.clear();
        code.append("// each directly contained association with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Association)) continue;
            this.generateAssociationTemplate(code, (Association)me, generateInterfaces);
            listNames.add(Generator.getJMIIdentifier(me));
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// each directly contained StructType with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof StructureType)) continue;
            Generator.generateStructureTypeTemplate(code, (StructureType)me, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// each directly contained EnumType with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof EnumerationType) || Generator.isJavaType(((EnumerationType)me).getName())) continue;
            Generator.generateEnumerationTypeTemplate(code, (EnumerationType)me, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        if (!generateInterfaces) {
            CodeContainer cc = new CodeContainer();
            Generator.generateTemplateRefPackage(cc, mofPackage, javaClassName);
            code.append(cc.toString());
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }

    public static String getPackageClassNameByPackageName(String packageName) {
        String nameOK = packageName;
        int n = packageName.lastIndexOf(46);
        if (n > 0) {
            String name = packageName.substring(n + 1);
            nameOK = packageName.substring(0, n) + '.' + name + '.' + name;
            nameOK = Generator.correctQualifiedName(nameOK);
        }
        return nameOK;
    }

    private void generatePackageTemplate(StringBuffer code, MofPackage mofPackage, String packageNameQualified, String accessorName, boolean generateInterfaces) {
        code.append("public ");
        code.append(packageNameQualified);
        code.append(" get");
        code.append(accessorName);
        code.append("()");
        if (generateInterfaces) {
            code.append(";");
        } else {
            code.append(" { return (" + packageNameQualified + ") refPackage(\"" + mofPackage.getName() + "\"); } ");
        }
        code.append(Utilities.SystemLineSeparator);
    }

    private void generatePackageTemplateClusteredPackage(StringBuffer code, MofPackage mofPackage, String packageNameQualified, String accessorName, boolean generateInterfaces) {
        code.append("public ");
        code.append(packageNameQualified);
        code.append(" get");
        code.append(accessorName);
        code.append("()");
        if (generateInterfaces) {
            code.append(";");
        } else {
            code.append(" { return (" + packageNameQualified + ") refPackage(\"" + mofPackage.getName() + "\"); } ");
        }
        code.append(Utilities.SystemLineSeparator);
    }

    private void generateClassTemplate(StringBuffer code, MofClass mofClass, boolean generateInterfaces) {
        if (mofClass.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) || !generateInterfaces) {
            String qName = Generator.getJMIIdentifierQualified((Namespace)mofClass);
            code.append("public ");
            code.append(qName);
            code.append("Class");
            code.append(" get");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)mofClass)));
            code.append("()");
            if (generateInterfaces) {
                code.append(";");
            } else {
                code.append(" { return (" + qName + "Class" + ") refClass(\"" + mofClass.getName() + "\"); } ");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private void generateAssociationTemplate(StringBuffer code, Association association, boolean generateInterfaces) {
        if (association.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) || !generateInterfaces) {
            String qName = Generator.getJMIIdentifierQualified((Namespace)association);
            code.append("public ");
            code.append(qName);
            code.append(" get");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)association)));
            code.append("()");
            if (generateInterfaces) {
                code.append(";");
            } else {
                code.append(" { return (" + qName + ") refAssociation(\"" + association.getName() + "\"); } ");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }
}

