/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.javamodel;

import com.sap.ip.mmr.generate.javamodel.JavaAttribute;
import com.sap.ip.mmr.generate.javamodel.JavaConstant;
import com.sap.ip.mmr.generate.javamodel.JavaElement;
import com.sap.ip.mmr.generate.javamodel.JavaImport;
import com.sap.ip.mmr.generate.javamodel.JavaMethod;
import com.sap.ip.mmr.generate.javamodel.JavaMethodGet;
import com.sap.ip.mmr.generate.javamodel.JavaMethodSet;
import com.sap.ip.mmr.generate.javamodel.JavaPackage;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaClass
extends JavaElement {
    JavaPackage immediatePackage = null;
    List imports = new ArrayList();
    List constants = new ArrayList();
    List attributes = new ArrayList();
    List methods = new ArrayList();

    public JavaClass(JavaPackage immediatePackage, String name) {
        super(name);
        this.immediatePackage = immediatePackage;
    }

    public static String correctName(String name) {
        return Generator.correctQualifiedName(name);
    }

    public String getQualifiedName() {
        if (this.immediatePackage == null) {
            return this.name;
        }
        return this.immediatePackage.getQualifiedName() + "." + this.name;
    }

    protected List getCode() {
        ArrayList<String> code = new ArrayList<String>();
        code.add("package " + this.immediatePackage.getQualifiedName() + ";");
        code.add("");
        Iterator iter = this.imports.iterator();
        while (iter.hasNext()) {
            JavaImport javaImport = (JavaImport)iter.next();
            this.addToCode(code, javaImport.getCode(), 3);
        }
        code.add("");
        code.add("public class " + this.name + " {");
        code.add("");
        code.add("   // constants");
        iter = this.constants.iterator();
        while (iter.hasNext()) {
            JavaConstant javaConstant = (JavaConstant)iter.next();
            this.addToCode(code, javaConstant.getCode(), 3);
        }
        code.add("");
        code.add("   // attributes");
        iter = this.attributes.iterator();
        while (iter.hasNext()) {
            JavaAttribute javaAttribute = (JavaAttribute)iter.next();
            this.addToCode(code, javaAttribute.getCode(), 3);
        }
        code.add("");
        code.add("   // methods");
        iter = this.methods.iterator();
        while (iter.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iter.next();
            this.addToCode(code, javaMethod.getCode(), 3);
        }
        code.add("");
        this.generateKeyClass(code);
        code.add("}");
        return code;
    }

    protected void generateKeyClass(List code) {
        JavaAttribute ja;
        JavaAttribute ja2;
        String className = this.getName() + "ID";
        code.add("  // JOD key class");
        code.add("  static public class " + className + " {");
        ArrayList<JavaAttribute> keys = new ArrayList<JavaAttribute>();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            ja2 = (JavaAttribute)iter.next();
            if (!ja2.isKey()) continue;
            keys.add(ja2);
        }
        iter = keys.iterator();
        while (iter.hasNext()) {
            ja2 = (JavaAttribute)iter.next();
            if (!ja2.isKey()) continue;
            code.add("    public " + ja2.getType() + " " + ja2.getName() + ";");
        }
        code.add("    public " + className + "() { }");
        String s = "    public " + className + "(";
        iter = keys.iterator();
        while (iter.hasNext()) {
            ja = (JavaAttribute)iter.next();
            if (!ja.isKey()) continue;
            s = s + ja.getType() + " " + ja.getName();
            if (!iter.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ") {";
        code.add(s);
        iter = keys.iterator();
        while (iter.hasNext()) {
            ja = (JavaAttribute)iter.next();
            if (!ja.isKey()) continue;
            code.add("      this." + ja.getName() + " = " + ja.getName() + ";");
        }
        code.add("    }");
        code.add("  }");
    }

    public void addImport(JavaImport javaImport) {
        this.imports.add(javaImport);
    }

    public void addConstant(JavaConstant javaConstant) {
        this.constants.add(javaConstant);
    }

    public void addAttribute(JavaAttribute javaAttribute) {
        this.attributes.add(javaAttribute);
        this.addMethod(new JavaMethodGet(javaAttribute));
        if (javaAttribute.getMultiplicity() == 1) {
            this.addMethod(new JavaMethodSet(javaAttribute));
        }
    }

    public void addMethod(JavaMethod javaMethod) {
        this.methods.add(javaMethod);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getImports() {
        return this.imports;
    }

    public List getMethods() {
        return this.methods;
    }

    public List getConstants() {
        return this.constants;
    }
}

