/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.workingset;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.util.Resources;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.PropertyChange;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkingSetManager {
    public static final String CHANGE_WORKING_SET_ADD = "workingSetAdd";
    public static final String CHANGE_WORKING_SET_REMOVE = "workingSetRemove";
    public static final String CHANGE_WORKING_SET_CONTENT_CHANGE = "workingSetContentChange";
    public static final String CHANGE_WORKING_SET_NAME_CHANGE = "workingSetNameChange";
    public static final String CHANGE_WORKING_SETS_SYNCH = "workingSetsSynch";
    private static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private SortedSet workingSets = new TreeSet(new WorkingSetComparator());
    private String locale;
    private PropertyChange.ListenerList propertyChangeListeners = new PropertyChange.ListenerList();
    private AdaptableTocsArray root;

    public WorkingSetManager(String locale) {
        this.locale = locale != null ? locale : BootLoader.getNL();
        this.restoreState();
    }

    public AdaptableTocsArray getRoot() {
        if (this.root == null) {
            this.root = new AdaptableTocsArray(HelpSystem.getTocManager().getTocs(this.locale));
        }
        return this.root;
    }

    public void addWorkingSet(WorkingSet workingSet) {
        if (workingSet == null || this.workingSets.contains(workingSet)) {
            return;
        }
        this.workingSets.add(workingSet);
        this.saveState();
        this.firePropertyChange(CHANGE_WORKING_SET_ADD, null, workingSet);
    }

    public void addPropertyChangeListener(PropertyChange.IPropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements) {
        return new WorkingSet(name, elements);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSetManager) {
            WorkingSetManager workingSetManager = (WorkingSetManager)object;
            return workingSetManager.workingSets.equals(this.workingSets);
        }
        return false;
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        PropertyChange.PropertyChangeEvent event = new PropertyChange.PropertyChangeEvent(this, changeId, oldValue, newValue);
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((PropertyChange.IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public WorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        Iterator iter = this.workingSets.iterator();
        while (iter.hasNext()) {
            WorkingSet workingSet = (WorkingSet)iter.next();
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public int hashCode() {
        return this.workingSets.hashCode();
    }

    public WorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new WorkingSet[this.workingSets.size()]);
    }

    private File getWorkingSetStateFile() {
        IPath path = HelpPlugin.getDefault().getStateLocation();
        path = path.append(this.locale);
        path = path.append(WORKING_SET_STATE_FILENAME);
        return path.toFile();
    }

    public void removeWorkingSet(WorkingSet workingSet) {
        this.workingSets.remove(workingSet);
        this.saveState();
        this.firePropertyChange(CHANGE_WORKING_SET_REMOVE, workingSet, null);
    }

    public boolean restoreState() {
        File stateFile = this.getWorkingSetStateFile();
        if (stateFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(stateFile);
                InputStreamReader reader = new InputStreamReader((InputStream)input, "utf-8");
                InputSource inputSource = new InputSource(reader);
                inputSource.setSystemId(stateFile.toString());
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                if (parser.getDocument() == null) {
                    return false;
                }
                Element rootElement = parser.getDocument().getDocumentElement();
                this.restoreWorkingSetState(rootElement);
                input.close();
                return true;
            }
            catch (SAXException se) {
                String msg = Resources.getString("E018", stateFile.toString());
                HelpPlugin.logError(msg, se);
                HelpPlugin.logError(Resources.getString("E041"), se);
                return false;
            }
            catch (IOException ioe) {
                String msg = Resources.getString("E018", stateFile.toString());
                HelpPlugin.logError(msg, ioe);
                HelpPlugin.logError(Resources.getString("E041"), ioe);
                return false;
            }
        }
        return false;
    }

    private void restoreWorkingSetState(Element parent) {
        NodeList workingSets = parent.getChildNodes();
        int i = 0;
        while (i < workingSets.getLength()) {
            WorkingSet workingSet;
            if (workingSets.item(i).getNodeType() == 1 && (workingSet = this.restoreWorkingSet((Element)workingSets.item(i))) != null) {
                this.workingSets.add(workingSet);
            }
            ++i;
        }
    }

    private WorkingSet restoreWorkingSet(Element workingSetNode) {
        String name = workingSetNode.getAttribute("name");
        NodeList items = workingSetNode.getElementsByTagName("item");
        ArrayList<AdaptableHelpResource> helpResources = new ArrayList<AdaptableHelpResource>(items.getLength());
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            String href = item.getAttribute("toc");
            if (href != null && href.length() != 0) {
                AdaptableToc toc;
                String child_pos = item.getAttribute("topic");
                int pos = -1;
                if (child_pos != null) {
                    try {
                        pos = Integer.parseInt(child_pos);
                    }
                    catch (Exception exception) {}
                }
                if ((toc = this.getAdaptableToc(href)) == null) {
                    return null;
                }
                if (pos == -1) {
                    helpResources.add(toc);
                } else {
                    AdaptableTopic[] topics = (AdaptableTopic[])((AdaptableHelpResource)toc).getChildren();
                    if (pos >= 0 && topics.length > pos) {
                        helpResources.add(topics[pos]);
                    }
                }
            }
            ++i;
        }
        AdaptableHelpResource[] elements = new AdaptableHelpResource[helpResources.size()];
        helpResources.toArray(elements);
        WorkingSet ws = this.createWorkingSet(name, elements);
        return ws;
    }

    public void removePropertyChangeListener(PropertyChange.IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public synchronized boolean saveState() {
        DocumentImpl doc = new DocumentImpl();
        Element rootElement = doc.createElement("workingSets");
        doc.appendChild(rootElement);
        this.saveWorkingSetState(rootElement);
        File stateFile = this.getWorkingSetStateFile();
        try {
            stateFile.getParentFile().mkdir();
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputFormat format = new OutputFormat();
            format.setEncoding("UTF-8");
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((OutputStream)stream, format);
            serializer.asDOMSerializer().serialize((Document)doc);
            stream.close();
            return true;
        }
        catch (IOException iOException) {
            stateFile.delete();
            String message = Resources.getString("E40");
            HelpPlugin.logError(message, null);
            return false;
        }
    }

    private void saveWorkingSetState(Element parent) {
        Iterator iterator = this.workingSets.iterator();
        while (iterator.hasNext()) {
            WorkingSet workingSet = (WorkingSet)iterator.next();
            workingSet.saveState(parent);
        }
    }

    public void workingSetChanged(WorkingSet changedWorkingSet) {
        this.saveState();
        this.firePropertyChange(CHANGE_WORKING_SET_NAME_CHANGE, null, changedWorkingSet);
        this.firePropertyChange(CHANGE_WORKING_SET_CONTENT_CHANGE, null, changedWorkingSet);
    }

    public void synchronizeWorkingSets() {
        this.firePropertyChange(CHANGE_WORKING_SETS_SYNCH, null, null);
    }

    public AdaptableToc getAdaptableToc(String href) {
        return this.getRoot().getAdaptableToc(href);
    }

    public AdaptableTopic getAdaptableTopic(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        int len = id.length();
        if (id.charAt(len - 1) == '_') {
            String indexStr = id.substring(id.lastIndexOf(95, len - 2) + 1, len - 1);
            int index = 0;
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (Exception exception) {}
            String tocStr = id.substring(0, id.lastIndexOf(95, len - 2));
            AdaptableToc toc = this.getAdaptableToc(tocStr);
            if (toc == null) {
                return null;
            }
            AdaptableHelpResource[] topics = toc.getChildren();
            if (index < 0 || index >= topics.length) {
                return null;
            }
            return (AdaptableTopic)topics[index];
        }
        return null;
    }
}

