/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.util.Resources;
import org.xml.sax.SAXParseException;

public class RuntimeHelpStatus {
    private static RuntimeHelpStatus inst = null;
    private ArrayList errorList = new ArrayList();
    private ArrayList badFilesList = new ArrayList();
    private ArrayList parserErrorMessagesList = new ArrayList();

    public synchronized void addError(Status status) {
        this.errorList.add(status);
    }

    public synchronized void addParseError(String message, String invalidFileName) {
        if (!this.badFilesList.contains(invalidFileName)) {
            this.badFilesList.add(invalidFileName);
        }
        this.parserErrorMessagesList.add(message);
    }

    public synchronized void addParseError(String message, SAXParseException parseException) {
        if (!this.badFilesList.contains(parseException)) {
            this.badFilesList.add(parseException);
        }
        this.parserErrorMessagesList.add(message);
    }

    public boolean errorsExist() {
        return !this.errorList.isEmpty() || !this.parserErrorMessagesList.isEmpty() || !this.badFilesList.isEmpty();
    }

    public static synchronized RuntimeHelpStatus getInstance() {
        if (inst == null) {
            inst = new RuntimeHelpStatus();
        }
        return inst;
    }

    public void reset() {
        this.errorList.clear();
        this.badFilesList.clear();
        this.parserErrorMessagesList.clear();
    }

    public synchronized String toString() {
        int i;
        StringBuffer fullText = new StringBuffer();
        if (!this.errorList.isEmpty()) {
            fullText.append(Resources.getString("E006"));
            fullText.append("******************** \n");
            i = 0;
            while (i < this.errorList.size()) {
                fullText.append(((Status)this.errorList.get(i)).getMessage());
                fullText.append("\n");
                ++i;
            }
        }
        if (fullText.length() > 0) {
            fullText.append("\n");
        }
        if (!this.parserErrorMessagesList.isEmpty()) {
            fullText.append(Resources.getString("E007"));
            fullText.append("********************  \n");
            i = 0;
            while (i < this.badFilesList.size()) {
                fullText.append((String)this.badFilesList.get(i));
                fullText.append("\n");
                ++i;
            }
            fullText.append("\n");
            fullText.append(Resources.getString("E008"));
            fullText.append("********************  \n");
            i = 0;
            while (i < this.parserErrorMessagesList.size()) {
                fullText.append((String)this.parserErrorMessagesList.get(i));
                fullText.append("\n");
                ++i;
            }
        }
        if (fullText.length() > 0) {
            return fullText.toString();
        }
        return "null status object";
    }
}

