/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.List;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class Topic
extends TocNode
implements ITopic {
    private String href;
    private String label;
    private ITopic[] topicArray;

    protected Topic(TocFile tocFile, Attributes attrs) throws SAXException {
        if (attrs == null) {
            return;
        }
        this.href = attrs.getValue("href");
        if (this.href != null && this.href.length() > 0) {
            this.href = HrefUtil.normalizeHref(tocFile.getPluginID(), this.href);
        }
        this.label = attrs.getValue("label");
    }

    public final void build(TocBuilder builder) {
        builder.buildTopic(this);
    }

    public String getHref() {
        return this.href;
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic[] getSubtopics() {
        if (this.topicArray == null) {
            List topics = this.getChildTopics();
            this.topicArray = new ITopic[topics.size()];
            topics.toArray(this.topicArray);
            this.children = null;
            this.parents = null;
        }
        return this.topicArray;
    }

    void setLabel(String label) {
        this.label = label;
    }

    void setHref(String href) {
        this.href = href;
    }
}

