/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.util.Resources;

public class TocManager {
    private Map tocsByLang;
    private Collection contributingPlugins;

    public TocManager() {
        try {
            this.tocsByLang = new HashMap();
            this.build(BootLoader.getNL());
        }
        catch (Exception e) {
            HelpPlugin.logError("", e);
        }
    }

    public IToc[] getTocs(String locale) {
        if (locale == null) {
            return new IToc[0];
        }
        IToc[] tocs = (IToc[])this.tocsByLang.get(locale);
        if (tocs == null) {
            TocManager tocManager = this;
            synchronized (tocManager) {
                if (tocs == null) {
                    this.build(locale);
                }
            }
            tocs = (IToc[])this.tocsByLang.get(locale);
            if (tocs == null) {
                tocs = new IToc[]{};
            }
        }
        return tocs;
    }

    public IToc getToc(String href, String locale) {
        if (href == null || href.equals("")) {
            return null;
        }
        IToc[] tocs = this.getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            if (tocs[i].getHref().equals(href)) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public Collection getContributingPlugins() {
        return this.contributingPlugins;
    }

    private void build(String locale) {
        IToc[] tocs;
        try {
            Collection contributedTocFiles = this.getContributedTocFiles(locale);
            TocBuilder builder = new TocBuilder();
            builder.build(contributedTocFiles);
            Collection builtTocs = builder.getBuiltTocs();
            tocs = new IToc[builtTocs.size()];
            int i = 0;
            Iterator it = builtTocs.iterator();
            while (it.hasNext()) {
                tocs[i++] = (IToc)it.next();
            }
            Collection orderedTocs = this.orderTocs(builtTocs);
            tocs = new IToc[orderedTocs.size()];
            orderedTocs.toArray(tocs);
        }
        catch (Exception e) {
            tocs = new IToc[]{};
            HelpPlugin.logError("", e);
        }
        this.tocsByLang.put(locale, tocs);
    }

    private Collection orderTocs(Collection unorderedTocs) {
        ArrayList orderedHrefs = this.getPreferredTocOrder();
        ArrayList<IToc> orderedTocs = new ArrayList<IToc>(unorderedTocs.size());
        Iterator it = ((AbstractList)orderedHrefs).iterator();
        while (it.hasNext()) {
            String href = (String)it.next();
            IToc toc = this.getToc(unorderedTocs, href);
            if (toc == null) continue;
            orderedTocs.add(toc);
        }
        it = unorderedTocs.iterator();
        while (it.hasNext()) {
            IToc toc = (IToc)it.next();
            if (orderedTocs.contains(toc)) continue;
            orderedTocs.add(toc);
        }
        return orderedTocs;
    }

    private ArrayList getPreferredTocOrder() {
        ArrayList<Object> orderedTocs = new ArrayList<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("baseTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    orderedTocs.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError(Resources.getString("E039"), e);
        }
        return orderedTocs;
    }

    private IToc getToc(Collection list, String href) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IToc toc = (IToc)it.next();
            if (!toc.getHref().equals(href)) continue;
            return toc;
        }
        return null;
    }

    protected Collection getContributedTocFiles(String locale) {
        this.contributingPlugins = new HashSet();
        ArrayList<TocFile> contributedTocFiles = new ArrayList<TocFile>();
        IExtensionPoint xpt = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.help", "toc");
        if (xpt == null) {
            return contributedTocFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.contributingPlugins.add(extensions[i].getDeclaringPluginDescriptor());
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("toc")) {
                    String pluginId = configElements[j].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                    String href = configElements[j].getAttribute("file");
                    boolean isPrimary = "true".equals(configElements[j].getAttribute("primary"));
                    String extraDir = configElements[j].getAttribute("extradir");
                    if (href != null) {
                        contributedTocFiles.add(new TocFile(pluginId, href, isPrimary, locale, extraDir));
                    }
                }
                ++j;
            }
            ++i;
        }
        return contributedTocFiles;
    }
}

