/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.Anchor;
import org.eclipse.help.internal.toc.Link;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.eclipse.help.internal.toc.Topic;
import org.eclipse.help.internal.util.FastStack;
import org.eclipse.help.internal.util.Resources;
import org.eclipse.help.internal.util.RuntimeHelpStatus;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class TocFileParser
extends DefaultHandler {
    protected TocBuilder builder;
    protected FastStack elementStack;
    protected TocFile tocFile;
    private static XMLParserPool parserPool = new XMLParserPool();

    public TocFileParser(TocBuilder builder) {
        this.builder = builder;
    }

    public void error(SAXParseException ex) throws SAXException {
        String message = this.getMessage("E024", ex);
        HelpPlugin.logError(message, null);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        String message = this.getMessage("E025", ex);
        HelpPlugin.logError(message, ex);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    protected String getMessage(String messageID, SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format(Resources.getString(messageID), param0, param1, param2, param3);
        return message;
    }

    public void parse(TocFile tocFile) {
        this.tocFile = tocFile;
        this.elementStack = new FastStack();
        InputStream is = tocFile.getInputStream();
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        String file = "/" + tocFile.getPluginID() + "/" + tocFile.getHref();
        inputSource.setSystemId(file);
        try {
            SAXParser parser = TocFileParser.parserPool.obtainParser();
            try {
                parser.setErrorHandler((ErrorHandler)this);
                parser.setContentHandler((ContentHandler)this);
                parser.parse(inputSource);
                is.close();
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                TocFileParser.parserPool.releaseParser(parser);
                throw throwable;
            }
            Object var6_10 = null;
            TocFileParser.parserPool.releaseParser(parser);
        }
        catch (SAXException se) {
            String msg = Resources.getString("E026", file);
            HelpPlugin.logError(msg, se);
        }
        catch (IOException ioe) {
            String msg = Resources.getString("E026", file);
            HelpPlugin.logError(msg, ioe);
            RuntimeHelpStatus.getInstance().addParseError(msg, file);
        }
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        TocNode node = null;
        if (qName.equals("toc")) {
            node = new Toc(this.tocFile, atts);
            this.tocFile.setToc((Toc)node);
        } else if (qName.equals("topic")) {
            node = new Topic(this.tocFile, atts);
        } else if (qName.equals("link")) {
            node = new Link(this.tocFile, atts);
        } else if (qName.equals("anchor")) {
            node = new Anchor(this.tocFile, atts);
        } else {
            return;
        }
        if (!this.elementStack.empty()) {
            ((TocNode)this.elementStack.peek()).addChild(node);
        }
        this.elementStack.push(node);
        node.build(this.builder);
    }

    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.elementStack.pop();
    }

    static class XMLParserPool {
        private ArrayList pool = new ArrayList();

        XMLParserPool() {
        }

        private SAXParser obtainParser() throws SAXException {
            SAXParser p;
            int free = this.pool.size();
            if (free > 0) {
                p = (SAXParser)this.pool.remove(free - 1);
            } else {
                p = new SAXParser();
                p.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            return p;
        }

        private void releaseParser(SAXParser parser) {
            this.pool.add(parser);
        }
    }
}

