/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.help.internal.standalone.Eclipse;
import org.eclipse.help.internal.standalone.EclipseConnection;
import org.eclipse.help.internal.standalone.Options;

public class EclipseController {
    private static final String CONTROL_SERVLET_PATH = "/helpControl/control.html";
    protected String applicationId;
    protected EclipseConnection connection;
    private Eclipse eclipse = null;

    public EclipseController(String applicationId, String[] args) {
        this.applicationId = applicationId;
        Options.init(applicationId, args);
        this.connection = this.initConnection();
    }

    protected EclipseConnection initConnection() {
        return new EclipseConnection();
    }

    public void shutdown() throws Exception {
        try {
            this.sendHelpCommand("shutdown", new String[0]);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
        this.connection.reset();
    }

    public void start() throws Exception {
        this.connection.reset();
        this.startEclipse();
    }

    protected void sendHelpCommand(String command, String[] parameters) throws Exception {
        if (!("shutdown".equalsIgnoreCase(command) || this.eclipse != null && this.eclipse.isAlive())) {
            this.startEclipse();
        }
        if (!this.connection.isValid()) {
            this.connection.renew();
        }
        try {
            URL url = this.createCommandURL(command, parameters);
            this.connection.connect(url);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    private URL createCommandURL(String command, String[] parameters) throws MalformedURLException {
        StringBuffer urlStr = new StringBuffer();
        urlStr.append("http://");
        urlStr.append(this.connection.getHost());
        urlStr.append(":");
        urlStr.append(this.connection.getPort());
        urlStr.append(CONTROL_SERVLET_PATH);
        urlStr.append("?command=");
        urlStr.append(command);
        int i = 0;
        while (i < parameters.length) {
            urlStr.append("&");
            urlStr.append(parameters[i]);
            ++i;
        }
        if (Options.isDebug()) {
            System.out.println("Control servlet URL=" + urlStr.toString());
        }
        return new URL(urlStr.toString());
    }

    private void startEclipse() throws Exception {
        if (Options.isDebug()) {
            System.out.println("Using workspace " + Options.getWorkspace().getAbsolutePath());
            System.out.println("Checking if file " + Options.getLockFile() + " exists.");
        }
        if (this.isAnotherRunning()) {
            return;
        }
        Options.getConnectionFile().delete();
        if (Options.isDebug()) {
            System.out.println("Ensured old .connection file is deleted.  Launching Eclipse.");
        }
        this.eclipse = new Eclipse();
        this.eclipse.start();
        while (this.eclipse.getStatus() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.eclipse.getStatus() == 2) {
            throw this.eclipse.getException();
        }
        if (Options.isDebug()) {
            System.out.println("Eclipse launched");
        }
    }

    private boolean isAnotherRunning() {
        if (!Options.getLockFile().exists()) {
            if (Options.isDebug()) {
                System.out.println("File " + Options.getLockFile() + " does not exist.  Eclipse needs to be started.");
            }
            return false;
        }
        if (System.getProperty("os.name").startsWith("Win")) {
            if (!Options.getLockFile().delete()) {
                if (Options.isDebug()) {
                    System.out.println("File " + Options.getLockFile() + " is locked.  Eclipse is already running.");
                }
                return true;
            }
            return false;
        }
        try {
            this.connection.renew();
            if (this.connection.getHost() != null && this.connection.getPort() != null) {
                URL url = this.createCommandURL("test", new String[0]);
                this.connection.connect(url);
                if (Options.isDebug()) {
                    System.out.println("Test connection to Eclipse established.  No need to start new Eclipse instance.");
                }
                return true;
            }
        }
        catch (Exception exception) {}
        if (Options.isDebug()) {
            System.out.println("Test connection to Eclipse could not be established.  Eclipse instance needs to be started.");
        }
        this.connection.reset();
        return false;
    }
}

