/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.help.internal.standalone.Options;

public class EclipseConnection {
    int startupTimeout;
    int connectionRetries;
    int connectionRetryInterval;
    private String host;
    private String port;

    public EclipseConnection() {
        this(0, 0, 5000);
    }

    public EclipseConnection(int startupTimeout, int connectionRetries, int connectionRetryInterval) {
        this.startupTimeout = startupTimeout;
        this.connectionRetries = connectionRetries;
        this.connectionRetryInterval = connectionRetryInterval;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void reset() {
        this.host = null;
        this.port = null;
    }

    public boolean isValid() {
        return this.host != null && this.port != null;
    }

    public void connect(URL url) throws InterruptedException, Exception {
        int i = 0;
        while (i <= this.connectionRetries) {
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (Options.isDebug()) {
                    System.out.println("Connection  to control servlet created.");
                }
                connection.connect();
                if (Options.isDebug()) {
                    System.out.println("Connection  to control servlet connected.");
                }
                int code = connection.getResponseCode();
                if (Options.isDebug()) {
                    System.out.println("Response code from control servlet=" + code);
                }
                connection.disconnect();
                return;
            }
            catch (IOException ioe) {
                if (Options.isDebug()) {
                    ioe.printStackTrace();
                }
                Thread.sleep(this.connectionRetryInterval);
                ++i;
            }
        }
        throw new Exception("Connection to Help System timed out.");
    }

    public void renew() throws Exception {
        long time1 = System.currentTimeMillis();
        while (!Options.getConnectionFile().exists()) {
            if (Options.isDebug()) {
                System.out.println("File " + Options.getConnectionFile() + " does not exist, at the moment.");
            }
            if (System.currentTimeMillis() - time1 >= (long)this.startupTimeout) {
                if (Options.isDebug()) {
                    System.out.println("Timeout waiting for file " + Options.getConnectionFile() + "\nEclipse is not running.");
                }
                throw new Exception("Timeout waiting for file " + Options.getConnectionFile() + "\nEclipse is not running.");
            }
            Thread.sleep(2000L);
        }
        Properties p = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(Options.getConnectionFile());
            p.load(is);
            is.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var6_7 = null;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        this.host = (String)((Hashtable)p).get("host");
        this.port = (String)((Hashtable)p).get("port");
        if (Options.isDebug()) {
            System.out.println("Help server host=" + this.host);
        }
        if (Options.isDebug()) {
            System.out.println("Help server port=" + this.port);
        }
    }
}

