/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;

public class SearchResults
implements ISearchHitCollector {
    private Collection scopeNames;
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];
    static /* synthetic */ Class class$0;

    public SearchResults(Collection scopeNames, int maxHits, String locale) {
        this.scopeNames = scopeNames;
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes();
    }

    public void addHits(Hits hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode(highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        float lastScore = Float.MAX_VALUE;
        int h = 0;
        while (h < hits.length() && h < this.maxHits) {
            block19: {
                AdaptableHelpResource scope;
                IToc toc;
                String href;
                float score;
                Document doc;
                block21: {
                    block20: {
                        try {
                            doc = hits.doc(h);
                            score = hits.score(h);
                        }
                        catch (IOException iOException) {
                            break block19;
                        }
                        href = doc.get("name");
                        toc = null;
                        scope = null;
                        if (this.scopeNames != null) break block20;
                        toc = this.getTocForTopic(href, this.locale);
                        break block21;
                    }
                    scope = this.getScopeForTopic(href);
                    if (scope == null) break block19;
                    if (scope instanceof AdaptableToc) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.help.IToc");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        toc = (IToc)scope.getAdapter(clazz);
                    } else {
                        IAdaptable iAdaptable = scope.getParent();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.help.IToc");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        toc = (IToc)iAdaptable.getAdapter((Class)clazz);
                    }
                }
                if (!scoreScaleSet) {
                    if (score > 0.0f) {
                        lastScore = score;
                        scoreScale = 0.99f / score;
                        score = 1.0f;
                    }
                    scoreScaleSet = true;
                } else {
                    if (score > lastScore) {
                        scoreScale = scoreScale * lastScore / score;
                    }
                    lastScore = score;
                    score = score * scoreScale + 0.01f;
                }
                String label = doc.get("raw_title");
                if ("".equals(label) && toc != null) {
                    label = scope != null ? scope.getTopic(href).getLabel() : toc.getTopic(href).getLabel();
                }
                if (label == null || "".equals(label)) {
                    label = href;
                }
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
                searchHitList.add(new SearchHit(href, label, score, toc));
            }
            ++h;
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        int i = 0;
        while (i < this.scopes.size()) {
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) != null) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        IToc[] tocs = HelpSystem.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes() {
        if (this.scopes != null) {
            return this.scopes;
        }
        if (this.scopeNames == null) {
            return null;
        }
        this.scopes = new ArrayList(this.scopeNames.size());
        WorkingSetManager wsmgr = HelpSystem.getWorkingSetManager(this.locale);
        Iterator it = this.scopeNames.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            WorkingSet ws = wsmgr.getWorkingSet(s);
            if (ws != null) {
                AdaptableHelpResource[] elements = ws.getElements();
                int i = 0;
                while (i < elements.length) {
                    this.scopes.add(elements[i]);
                    ++i;
                }
                continue;
            }
            AdaptableToc toc = wsmgr.getAdaptableToc(s);
            if (toc == null) continue;
            this.scopes.add(toc);
        }
        return this.scopes;
    }
}

