/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.LazyProgressMonitor;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.util.HelpProperties;
import org.eclipse.help.internal.util.Resources;

class IndexingOperation {
    private int numAdded;
    private int numRemoved;
    private SearchIndex index = null;
    private static final int WORK_PREPARE = 1;
    private static final int WORK_DELETEDOC = 5;
    private static final int WORK_INDEXDOC = 50;
    private static final int WORK_SAVEINDEX = 2;
    private int workTotal;

    public IndexingOperation(SearchIndex ix) {
        this.index = ix;
    }

    private void checkCancelled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void execute(IProgressMonitor pm) throws OperationCanceledException, IndexingException {
        Collection removedDocs = this.getRemovedDocuments(this.index);
        this.numRemoved = removedDocs.size();
        Collection addedDocs = this.getAddedDocuments(this.index);
        this.numAdded = addedDocs.size();
        this.workTotal = (this.numRemoved + this.numAdded) * 1 + this.numAdded * 50 + (this.numRemoved + this.numAdded) * 2;
        if (this.numRemoved > 0) {
            this.workTotal += (this.numRemoved + this.numAdded) * 1 + this.numRemoved * 5 + (this.numRemoved + this.numAdded) * 2;
        }
        if (this.numRemoved + this.numAdded <= 0) {
            pm.done();
            return;
        }
        LazyProgressMonitor monitor = new LazyProgressMonitor(pm);
        monitor.beginTask("", this.workTotal);
        this.removeDocuments((IProgressMonitor)monitor, removedDocs);
        this.addDocuments((IProgressMonitor)monitor, addedDocs);
        monitor.done();
    }

    private void addDocuments(IProgressMonitor pm, Collection addedDocs) throws IndexingException {
        if (!this.index.beginAddBatch()) {
            throw new IndexingException();
        }
        try {
            this.checkCancelled(pm);
            pm.worked((this.numRemoved + this.numAdded) * 1);
            pm.subTask(Resources.getString("UpdatingIndex"));
            Iterator it = addedDocs.iterator();
            while (it.hasNext()) {
                URL doc = (URL)it.next();
                this.index.addDocument(this.getName(doc), doc);
                this.checkCancelled(pm);
                pm.worked(50);
            }
        }
        catch (OperationCanceledException oce) {
            pm.subTask(Resources.getString("Undoing_document_adds"));
            pm.worked(this.workTotal);
            throw oce;
        }
        pm.subTask(Resources.getString("Writing_index"));
        if (!this.index.endAddBatch()) {
            throw new IndexingException();
        }
    }

    private void removeDocuments(IProgressMonitor pm, Collection removedDocs) throws IndexingException {
        pm.subTask(Resources.getString("Preparing_for_indexing"));
        this.checkCancelled(pm);
        if (this.numRemoved > 0) {
            if (!this.index.beginDeleteBatch()) {
                throw new IndexingException();
            }
            try {
                this.checkCancelled(pm);
                pm.worked((this.numRemoved + this.numAdded) * 1);
                pm.subTask(Resources.getString("UpdatingIndex"));
                Iterator it = removedDocs.iterator();
                while (it.hasNext()) {
                    URL doc = (URL)it.next();
                    this.index.removeDocument(this.getName(doc));
                    this.checkCancelled(pm);
                    pm.worked(5);
                }
            }
            catch (OperationCanceledException oce) {
                pm.subTask(Resources.getString("Undoing_document_deletions"));
                pm.worked(this.workTotal);
                throw oce;
            }
            if (!this.index.endDeleteBatch()) {
                throw new IndexingException();
            }
            pm.worked((this.numRemoved + this.numAdded) * 2);
        }
    }

    private String getName(URL doc) {
        String name = doc.getFile();
        int i = name.indexOf(63);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private Collection getAddedDocuments(SearchIndex index) {
        Collection addedPlugins = index.getDocPlugins().getAdded();
        if (addedPlugins == null || addedPlugins.isEmpty()) {
            return new ArrayList(0);
        }
        Set urls = this.getAllDocuments(index.getLocale());
        HashSet<URL> addedDocs = new HashSet<URL>(urls.size());
        Iterator docs = urls.iterator();
        while (docs.hasNext()) {
            URL url;
            String plugin;
            String doc = (String)docs.next();
            int i = doc.indexOf(47, 1);
            String string = plugin = i == -1 ? "" : doc.substring(1, i);
            if (!addedPlugins.contains(plugin) || (url = this.getIndexableURL(doc)) == null) continue;
            addedDocs.add(url);
        }
        return addedDocs;
    }

    private Collection getRemovedDocuments(SearchIndex index) {
        Collection removedPlugins = index.getDocPlugins().getRemoved();
        if (removedPlugins == null || removedPlugins.isEmpty()) {
            return new ArrayList(0);
        }
        HelpProperties indexedDocs = index.getIndexedDocs();
        HashSet<URL> removedDocs = new HashSet<URL>(((Hashtable)indexedDocs).size());
        Iterator docs = ((Hashtable)indexedDocs).keySet().iterator();
        while (docs.hasNext()) {
            URL url;
            String plugin;
            String doc = (String)docs.next();
            int i = doc.indexOf(47, 1);
            String string = plugin = i == -1 ? "" : doc.substring(1, i);
            if (!removedPlugins.contains(plugin) || (url = this.getIndexableURL(doc)) == null) continue;
            removedDocs.add(url);
        }
        return removedDocs;
    }

    private void add(ITopic topic, Set hrefs) {
        String href = topic.getHref();
        if (href != null && !href.equals("") && !href.startsWith("http://")) {
            hrefs.add(href);
        }
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            this.add(subtopics[i], hrefs);
            ++i;
        }
    }

    private Set getAllDocuments(String locale) {
        HashSet hrefs = new HashSet();
        IToc[] tocs = HelpSystem.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic tocDescriptionTopic;
            ITopic[] topics = tocs[i].getTopics();
            int j = 0;
            while (j < topics.length) {
                this.add(topics[j], hrefs);
                ++j;
            }
            if (tocs[i] instanceof Toc) {
                topics = ((Toc)tocs[i]).getExtraTopics();
                j = 0;
                while (j < topics.length) {
                    this.add(topics[j], hrefs);
                    ++j;
                }
            }
            if ((tocDescriptionTopic = tocs[i].getTopic(null)) != null) {
                this.add(tocDescriptionTopic, hrefs);
            }
            ++i;
        }
        return hrefs;
    }

    private URL getIndexableURL(String url) {
        String fileName = url.toLowerCase();
        if (!(fileName.endsWith(".htm") || fileName.endsWith(".html") || fileName.endsWith(".txt") || fileName.endsWith(".xml"))) {
            if (fileName.indexOf(".htm#") >= 0 || fileName.indexOf(".html#") >= 0 || fileName.indexOf(".xml#") >= 0) {
                url = url.substring(0, url.lastIndexOf(35));
            } else {
                return null;
            }
        }
        try {
            return new URL("help:" + url + "?lang=" + this.index.getLocale());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public class IndexingException
    extends Exception {
    }
}

