/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.apache.lucene.analysis.Analyzer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.search.DefaultAnalyzer;
import org.eclipse.help.internal.search.SmartAnalyzer;
import org.eclipse.help.internal.util.Resources;

public class AnalyzerDescriptor {
    private Analyzer luceneAnalyzer;
    private String id;
    private String lang;

    public AnalyzerDescriptor(String locale) {
        this.luceneAnalyzer = this.createAnalyzer(locale);
        if (this.luceneAnalyzer == null) {
            String language = null;
            if (locale.length() > 2) {
                language = locale.substring(0, 2);
                this.luceneAnalyzer = this.createAnalyzer(language);
            }
        }
        if (this.luceneAnalyzer == null) {
            this.id = String.valueOf(HelpPlugin.getDefault().getDescriptor().getUniqueIdentifier()) + "#" + HelpPlugin.getDefault().getDescriptor().getVersionIdentifier().toString();
            this.luceneAnalyzer = new DefaultAnalyzer(locale);
            this.lang = locale;
        }
    }

    public Analyzer getAnalyzer() {
        return new SmartAnalyzer(this.lang, this.luceneAnalyzer);
    }

    public String getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    private Analyzer createAnalyzer(String locale) {
        IConfigurationElement[] configElements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.help", "luceneAnalyzer");
        int i = 0;
        while (i < configElements.length) {
            String analyzerLocale;
            if (configElements[i].getName().equals("analyzer") && (analyzerLocale = configElements[i].getAttribute("locale")) != null && analyzerLocale.equals(locale)) {
                try {
                    Object analyzer = configElements[i].createExecutableExtension("class");
                    if (analyzer instanceof Analyzer) {
                        String pluginId = configElements[i].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                        String pluginVersion = configElements[i].getDeclaringExtension().getDeclaringPluginDescriptor().getVersionIdentifier().toString();
                        this.luceneAnalyzer = (Analyzer)analyzer;
                        this.id = String.valueOf(pluginId) + "#" + pluginVersion;
                        this.lang = locale;
                        if (!"org.eclipse.help".equals(pluginId)) {
                            return this.luceneAnalyzer;
                        }
                    }
                }
                catch (CoreException ce) {
                    HelpPlugin.logError(Resources.getString("ES23", configElements[i].getAttribute("class"), locale), ce);
                }
            }
            ++i;
        }
        return this.luceneAnalyzer;
    }

    public boolean isCompatible(String analyzerId) {
        if (this.id.equals(analyzerId)) {
            return true;
        }
        return analyzerId.compareTo("org.eclipse.help#2.0.1") >= 0 && analyzerId.compareTo("org.eclipse.help#2.1.2") <= 0 && this.id.compareTo("org.eclipse.help#2.0.1") >= 0 && this.id.compareTo("org.eclipse.help#2.1.2") <= 0;
    }
}

