/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.browser.StreamConsumer;
import org.eclipse.help.internal.util.Resources;

public class CustomBrowser
implements IBrowser {
    public static final String CUSTOM_BROWSER_PATH_KEY = "custom_browser_path";

    public void close() {
    }

    public boolean isCloseSupported() {
        return false;
    }

    public void displayURL(String url) throws Exception {
        String path = HelpPlugin.getDefault().getPluginPreferences().getString(CUSTOM_BROWSER_PATH_KEY);
        String[] command = this.prepareCommand(path, url);
        try {
            Process pr = Runtime.getRuntime().exec(command);
            StreamConsumer outConsumer = new StreamConsumer(pr.getInputStream());
            outConsumer.setName("Custom browser adapter output reader");
            outConsumer.start();
            StreamConsumer errConsumer = new StreamConsumer(pr.getErrorStream());
            errConsumer.setName("Custom browser adapter error reader");
            errConsumer.start();
        }
        catch (Exception e) {
            HelpPlugin.logError(Resources.getString("CustomBrowser.errorLaunching", url, path), e);
            throw new Exception(Resources.getString("CustomBrowser.errorLaunching", url, path));
        }
    }

    public boolean isSetLocationSupported() {
        return false;
    }

    public boolean isSetSizeSupported() {
        return false;
    }

    public void setLocation(int x, int y) {
    }

    public void setSize(int width, int height) {
    }

    private String[] prepareCommand(String path, String url) {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer qTokenizer = new StringTokenizer(path.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    if ("win32".equalsIgnoreCase(BootLoader.getOS())) {
                        tokenList.add("\"" + quotedString + "\"");
                    } else {
                        tokenList.add(quotedString);
                    }
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                tokenList.add(parser.nextToken());
            }
        }
        boolean substituted = false;
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            if ("%1".equals(token)) {
                tokenList.set(i, url);
                substituted = true;
            } else if ("\"%1\"".equals(token)) {
                tokenList.set(i, "\"" + url + "\"");
                substituted = true;
            }
            ++i;
        }
        if (!substituted) {
            tokenList.add(url);
        }
        String[] command = new String[tokenList.size()];
        tokenList.toArray(command);
        return command;
    }
}

