/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.appserver.WebappManager;

public class HelpApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final int STATUS_EXITTING = 0;
    private static final int STATUS_RESTARTING = 2;
    private static final int STATUS_RUNNING = 1;
    private static int status = 1;

    public static void stop() {
        status = 0;
    }

    public static void restart() {
        if (status != 0) {
            status = 2;
        }
    }

    public Object run(Object args) throws Exception {
        if (!HelpSystem.ensureWebappRunning()) {
            System.out.println("Help web application could not start.  Check log file for details.");
            return IPlatformRunnable.EXIT_OK;
        }
        this.writeHostAndPort();
        while (status == 1) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (status == 2) {
            return IPlatformRunnable.EXIT_RESTART;
        }
        return IPlatformRunnable.EXIT_OK;
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        String value = (String)((Map)data).get("mode");
        if ("infocenter".equalsIgnoreCase(value)) {
            HelpSystem.setMode(1);
        } else if ("standalone".equalsIgnoreCase(value)) {
            HelpSystem.setMode(2);
        }
    }

    private void writeHostAndPort() throws IOException {
        block7: {
            Properties p = new Properties();
            ((Hashtable)p).put("host", WebappManager.getHost());
            ((Hashtable)p).put("port", "" + WebappManager.getPort());
            File workspace = Platform.getLocation().toFile();
            File hostPortFile = new File(workspace, ".metadata/.connection");
            hostPortFile.deleteOnExit();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(hostPortFile);
                p.store(out, null);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (out == null) break block7;
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

