/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.net.URLEncoder;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelp;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.ContextProxy;
import org.eclipse.help.internal.util.Resources;

public class DefaultHelpSupport
implements IHelp {
    private int idCounter = 0;

    public void displayHelp() {
        if (this.getTocs().length == 0) {
            HelpSystem.getDefaultErrorUtil().displayError(Resources.getString("WW001"));
            return;
        }
        this.displayHelpURL(null);
    }

    public void displayContext(IContext context, int x, int y) {
    }

    public void displayContext(String contextId, int x, int y) {
        IContext context = HelpSystem.getContextManager().getContext(contextId);
        this.displayContext(context, x, y);
    }

    public void displayHelpResource(IHelpResource helpResource) {
        if (helpResource instanceof IToc) {
            this.displayHelpURL("toc=" + URLEncoder.encode(helpResource.getHref()));
        } else if (helpResource instanceof ITopic) {
            this.displayHelpURL("topic=" + URLEncoder.encode(this.getTopicURL(helpResource.getHref())));
        } else {
            this.displayHelpResource(helpResource.getHref());
        }
    }

    public void displayHelpResource(String href) {
        IToc toc = HelpSystem.getTocManager().getToc(href, BootLoader.getNL());
        if (toc != null) {
            this.displayHelpResource(toc);
        } else if (href != null && (href.startsWith("tab=") || href.startsWith("toc=") || href.startsWith("topic=") || href.startsWith("contextId="))) {
            this.displayHelpURL(href);
        } else {
            this.displayHelpURL("topic=" + URLEncoder.encode(href));
        }
    }

    public void displayHelp(String tocFileHref) {
        this.displayHelp(tocFileHref, null);
    }

    public void displayHelp(String toc, String topic) {
        if (this.getTocs().length == 0) {
            HelpSystem.getDefaultErrorUtil().displayError(Resources.getString("WW001"));
            return;
        }
        String query = null;
        if (toc != null) {
            query = "toc=" + toc;
            if (topic != null) {
                query = String.valueOf(query) + "&topic=" + URLEncoder.encode(this.getTopicURL(topic));
            }
        } else if (topic != null) {
            query = "topic=" + URLEncoder.encode(this.getTopicURL(topic));
        }
        this.displayHelpURL(query);
    }

    public void displayHelp(String contextId, int x, int y) {
        this.displayContext(contextId, x, y);
    }

    public void displayHelp(IContext context, int x, int y) {
        this.displayContext(context, x, y);
    }

    public void displayHelp(IContext context, IHelpResource topic) {
        if (context == null || topic == null || topic.getHref() == null) {
            return;
        }
        String url = "tab=links&contextId=" + URLEncoder.encode(this.getContextID(context)) + "&topic=" + URLEncoder.encode(this.getTopicURL(topic.getHref()));
        this.displayHelpURL(url);
    }

    public void displaySearch(String searchQuery, String topic) {
        if (searchQuery == null || topic == null) {
            return;
        }
        String url = "tab=search&" + searchQuery + "&topic=" + URLEncoder.encode(this.getTopicURL(topic));
        this.displayHelpURL(url);
    }

    void displayHelpURL(String helpURL) {
        if (!HelpSystem.ensureWebappRunning()) {
            HelpSystem.getDefaultErrorUtil().displayError(Resources.getString("E043"));
            return;
        }
        try {
            if (helpURL == null || helpURL.length() == 0) {
                HelpSystem.getHelpBrowser().displayURL(this.getBaseURL());
            } else if (helpURL.startsWith("tab=") || helpURL.startsWith("toc=") || helpURL.startsWith("topic=") || helpURL.startsWith("contextId=")) {
                HelpSystem.getHelpBrowser().displayURL(String.valueOf(this.getBaseURL()) + "?" + helpURL);
            } else {
                HelpSystem.getHelpBrowser().displayURL(helpURL);
            }
        }
        catch (Exception e) {
            HelpSystem.getDefaultErrorUtil().displayError(e.getMessage());
        }
    }

    public IContext getContext(String contextID) {
        return new ContextProxy(contextID);
    }

    public IToc[] getTocs() {
        return HelpSystem.getTocManager().getTocs(BootLoader.getNL());
    }

    public boolean isContextHelpDisplayed() {
        return false;
    }

    private String getContextID(IContext context) {
        if (context instanceof Context) {
            return ((Context)context).getID();
        }
        if (context instanceof ContextProxy) {
            return ((ContextProxy)context).getID();
        }
        String id = "org.eclipse.help.ID" + this.idCounter++;
        HelpSystem.getContextManager().addContext(id, context);
        return id;
    }

    private String getBaseURL() {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/index.jsp";
    }

    private String getTopicURL(String topic) {
        if (topic == null) {
            return null;
        }
        if (topic.startsWith("../")) {
            topic = topic.substring(2);
        }
        return topic;
    }
}

