/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.designtime.DtColumnExpanded;
import com.sap.dictionary.designtime.DtDbTableExpanded;
import com.sap.dictionary.designtime.DtStructureChecker;
import com.sap.dictionary.designtime.DtStructureColumnExpanded;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.dictionary.designtime.ExpandException;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtImportFromOtherStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class DtStructureExpanded {
    protected String name = "";
    private String backendName = "";
    protected String author = "";
    protected String creationDate = "";
    protected String language = "";
    protected String description = "";
    protected DtStructure structure = null;
    protected DtStructureChecker checker = null;
    protected boolean withCheck;
    protected boolean expanded = true;
    protected ArrayList errorMessages = new ArrayList();
    protected HashMap gColumns = new HashMap();
    protected ArrayList gColumnsAsList = new ArrayList();
    protected TreeMap sortedFields = null;
    private ArrayList amountFieldCandidates = new ArrayList();
    private ArrayList referenceFieldCandidates = new ArrayList();
    private static final String CURR_PACKAGE = "com.sap.dictionary.predefined.currency";
    private static final String QUAN_PACKAGE = "com.sap.dictionary.predefined.quantity";

    public DtStructureExpanded() {
    }

    public DtStructureExpanded(DtStructure structure) {
        this.structure = structure;
        this.checker = new DtStructureChecker(structure);
        this.withCheck = true;
        this.expand(structure, 1, this.withCheck);
    }

    public DtStructureExpanded(DtStructure structure, boolean withCheck) {
        this.structure = structure;
        this.checker = new DtStructureChecker(structure);
        this.expand(structure, 1, withCheck);
    }

    protected DtStructureExpanded(DtStructure structure, int position, boolean withCheck) {
        this.structure = structure;
        this.checker = new DtStructureChecker(structure);
        this.withCheck = withCheck;
        this.expand(structure, position, withCheck);
    }

    protected boolean expand(DtStructure structure, int position, boolean withCheck) {
        boolean beforeExpand = true;
        boolean afterExpand = true;
        this.expandHeader(structure);
        if (withCheck) {
            boolean nameIsOk = this.checker.nameIsOk();
            boolean fieldsExist = this.checker.fieldsExist();
            if (this.backendName != null && !this.backendName.equalsIgnoreCase("") && !fieldsExist) {
                return nameIsOk;
            }
            boolean bl = beforeExpand = nameIsOk && fieldsExist;
            if (!beforeExpand) {
                this.expanded = false;
                return this.expanded;
            }
        }
        try {
            this.expandColumns(structure, position);
        }
        catch (ExpandException ex) {
            this.errorMessages.add(ex.getMessage());
            this.expanded = false;
            return this.expanded;
        }
        Iterator iter = ((AbstractList)this.gColumnsAsList).iterator();
        DtStructureColumnExpanded column = null;
        String typePrefix = "";
        String typeLocalName = "";
        String typeQualifiedName = "";
        while (iter.hasNext()) {
            column = (DtStructureColumnExpanded)iter.next();
            String builtInType = column.getBuiltInType();
            if (builtInType == null) continue;
            if (builtInType.equalsIgnoreCase("decimal")) {
                this.amountFieldCandidates.add(column.getName());
            }
            if ((typeQualifiedName = column.getTypeName()).lastIndexOf(46) <= -1) continue;
            typePrefix = typeQualifiedName.substring(0, typeQualifiedName.lastIndexOf(46));
            typeLocalName = typeQualifiedName.substring(typeQualifiedName.lastIndexOf(46) + 1, typeQualifiedName.length());
            if (typePrefix.equalsIgnoreCase(CURR_PACKAGE) && (typeLocalName.equalsIgnoreCase("currency") || typeLocalName.equalsIgnoreCase("currencyNormalized"))) {
                this.referenceFieldCandidates.add(column.getName());
            }
            if (!typePrefix.equalsIgnoreCase(QUAN_PACKAGE) || !typeLocalName.equalsIgnoreCase("quantity") && !typeLocalName.equalsIgnoreCase("quantityNormalized")) continue;
            this.referenceFieldCandidates.add(column.getName());
        }
        if (withCheck) {
            this.expanded = beforeExpand & this.isStructureOk();
        }
        return this.expanded;
    }

    protected void expandHeader(DtStructure dtStructure) {
        String prefix = "";
        this.name = dtStructure.getName();
        this.backendName = dtStructure.getBackendName();
        this.description = dtStructure.getDescription();
        if (dtStructure instanceof DtGeneralStructure) {
            prefix = ((DtGeneralStructure)dtStructure).getPackage();
            this.name = prefix + "." + this.name;
        }
    }

    protected void expandColumns(DtStructure structure, int position) {
        DtStructureElement[] dtStructureElements = structure.getStructureElements();
        if (dtStructureElements != null) {
            this.sortedFields = new TreeMap();
            int i = 0;
            while (i <= dtStructureElements.length - 1) {
                this.sortedFields.put(new Integer(dtStructureElements[i].getPosition()), dtStructureElements[i]);
                ++i;
            }
            DtStructureColumnExpanded gColumn = null;
            DtField dtField = null;
            DtStructureElement structureElement = null;
            Set keySet = this.sortedFields.keySet();
            Iterator iter = keySet.iterator();
            Object expColumn = null;
            while (iter.hasNext()) {
                structureElement = (DtStructureElement)this.sortedFields.get(iter.next());
                if (structureElement instanceof DtField) {
                    dtField = (DtField)structureElement;
                    gColumn = dtField.hasReferencedType() && dtField.getBuiltInType() == null ? (structure instanceof DtDbTable ? new DtColumnExpanded(dtField, position, (DtSimpleType)dtField.getReferencedType()) : new DtStructureColumnExpanded(dtField, position, (DtSimpleType)dtField.getReferencedType())) : (structure instanceof DtDbTable ? new DtColumnExpanded(dtField, position) : new DtStructureColumnExpanded(dtField, position));
                    this.gColumns.put(gColumn.getName(), gColumn);
                    this.gColumnsAsList.add(gColumn);
                    ++position;
                    continue;
                }
                if (!(structureElement instanceof DtImportFromOtherStructure)) continue;
                DtStructure dtStructure1 = ((DtImportFromOtherStructure)structureElement).getUsedStructure();
                DtStructureExpanded gStructure = new DtStructureExpanded(dtStructure1, position, false);
                HashMap appColumns = gStructure.getColumns();
                this.gColumns.putAll(appColumns);
                ArrayList appColumnsAsList = gStructure.getColumnsAsList();
                this.gColumnsAsList.addAll(appColumnsAsList);
                position = this.gColumns.size() + 1;
            }
        } else {
            this.expanded = false;
            this.errorMessages.add(ErrTexts.get("100"));
        }
    }

    public boolean isStructureOk() {
        ArrayList dbMessages = new ArrayList();
        ArrayList mess = new ArrayList();
        Object format = null;
        this.checker.setExpStructure(this);
        boolean nameIsOk = this.checker.nameIsOk();
        boolean fieldsExist = this.checker.fieldsExist();
        boolean noDuplicateFields = this.checker.noDuplicateFields();
        boolean fieldsAreOk = this.checker.fieldsAreOk();
        boolean referenceFieldsAreOk = this.checker.referenceFieldsAreOk();
        boolean IsOk = nameIsOk & fieldsExist & noDuplicateFields & fieldsAreOk & referenceFieldsAreOk;
        return IsOk;
    }

    public String getName() {
        return this.name;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public HashMap getColumns() {
        return this.gColumns;
    }

    public ArrayList getColumnsAsList() {
        return this.gColumnsAsList;
    }

    public ArrayList getAmountFieldCandidates() {
        return this.amountFieldCandidates;
    }

    public ArrayList getReferenceFieldCandidates() {
        return this.referenceFieldCandidates;
    }

    protected static String getCurrencyPackage() {
        return CURR_PACKAGE;
    }

    protected static String getQuantityPackage() {
        return QUAN_PACKAGE;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public ArrayList getErrorMessages() {
        if (this.expanded) {
            return new ArrayList();
        }
        HashMap independentMessages = this.checker.getMessages();
        Iterator iter = independentMessages.keySet().iterator();
        Object nextKey = null;
        while (iter.hasNext()) {
            nextKey = iter.next();
            String indMess = (String)independentMessages.get(nextKey);
            if (!indMess.equalsIgnoreCase("Error")) continue;
            this.errorMessages.add(nextKey);
        }
        String messagePrefix = "";
        if (this instanceof DtDbTableExpanded) {
            messagePrefix = "Table " + this.name + " ";
        } else if (this instanceof DtStructureExpanded) {
            messagePrefix = "Structure " + this.name + " ";
        }
        String text = messagePrefix + "is not generated";
        this.errorMessages.add(0, text);
        return this.errorMessages;
    }

    public ArrayList getWarningMessages() {
        ArrayList<String> warnings = new ArrayList<String>();
        HashMap independentMessages = this.checker.getMessages();
        Iterator iter = independentMessages.keySet().iterator();
        Object nextKey = null;
        while (iter.hasNext()) {
            nextKey = iter.next();
            String indMess = (String)independentMessages.get(nextKey);
            if (!indMess.equalsIgnoreCase("Warning")) continue;
            warnings.add(nextKey);
        }
        return warnings;
    }

    public ArrayList getInfoMessages() {
        ArrayList<String> infos = new ArrayList<String>();
        HashMap independentMessages = this.checker.getMessages();
        Iterator iter = independentMessages.keySet().iterator();
        Object nextKey = null;
        while (iter.hasNext()) {
            nextKey = iter.next();
            String indMess = (String)independentMessages.get(nextKey);
            if (!indMess.equalsIgnoreCase("Warning")) continue;
            infos.add(nextKey);
        }
        return infos;
    }

    public XmlMap getXmlMap() {
        XmlMap tableMap = new XmlMap();
        XmlMap body = new XmlMap();
        XmlMap columns = new XmlMap();
        body.put("name", this.name);
        Iterator iter = this.gColumns.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            columns.put("column" + (i == 0 ? "" : "" + i), ((DtStructureColumnExpanded)this.gColumns.get(iter.next())).getXmlMap());
            ++i;
        }
        body.put("columns", columns);
        tableMap.put("Dbtable", body);
        return tableMap;
    }

    public String toString() {
        Iterator iter = null;
        String s = null;
        s = "Table: " + this.name + "\n" + "\n";
        iter = this.gColumns.keySet().iterator();
        while (iter.hasNext()) {
            s = s + (DtStructureColumnExpanded)this.gColumns.get(iter.next()) + "\n";
        }
        return s + "\n";
    }
}

