/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtStructureColumnExpanded;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.ErrTexts;
import java.util.HashMap;

public class DtStructureColumnChecker {
    DtStructureColumnExpanded expColumn = null;
    String columnName = null;
    HashMap mess = new HashMap();

    public DtStructureColumnChecker() {
    }

    public DtStructureColumnChecker(DtStructureColumnExpanded expColumn, HashMap messages) {
        this.expColumn = expColumn;
        this.mess = messages;
        this.columnName = expColumn.getName();
    }

    public boolean nameIsOk() {
        String allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String allowedAtFirstPosition = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        HashMap<String, String> messages = new HashMap<String, String>();
        int ch = 32;
        int i = 0;
        while (i < this.columnName.length()) {
            ch = this.columnName.toUpperCase().charAt(i);
            if (allowedCharacters.indexOf(ch) == -1) {
                messages.put(ErrTexts.get("029"), "Error");
            }
            ++i;
        }
        ch = this.columnName.toUpperCase().charAt(0);
        if (allowedAtFirstPosition.indexOf(ch) == -1) {
            messages.put(ErrTexts.get("051"), "Error");
        }
        if (this.columnName.length() > 30) {
            messages.put(DtHelper.concat(ErrTexts.get("109"), this.columnName), "Error");
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean nameIsOk(String columnName) {
        this.columnName = columnName;
        return this.nameIsOk();
    }

    public boolean typeIsOk() {
        String fieldName = null;
        String ddType = null;
        fieldName = this.expColumn.getName();
        ddType = this.expColumn.getBuiltInType();
        String backendName = this.expColumn.getBackendName();
        if (backendName != null && !backendName.equals("") && ddType == null) {
            return true;
        }
        if (!DtTypeInfo.getBuiltInTypes().contains(ddType)) {
            this.mess.put(DtHelper.concat(ErrTexts.get("105"), ddType, fieldName), "Error");
            return false;
        }
        return true;
    }

    public boolean decimalIsOk() {
        int length = 0;
        int decimals = 0;
        String fieldName = null;
        String ddType = null;
        fieldName = this.expColumn.getName();
        ddType = this.expColumn.getBuiltInType();
        String backendName = this.expColumn.getBackendName();
        if (backendName != null && !backendName.equals("") && ddType == null) {
            return true;
        }
        if (ddType.equalsIgnoreCase("decimals")) {
            length = this.expColumn.getLength();
            decimals = this.expColumn.getDecimals();
            if (length == 0 || decimals == 0) {
                this.mess.put(DtHelper.concat(ErrTexts.get("107"), fieldName), "Error");
                return false;
            }
            if (decimals >= length) {
                this.mess.put(ErrTexts.get("122"), "Error");
                return false;
            }
        }
        return true;
    }

    public boolean referenceFieldIsOk(DtStructureColumnExpanded refField) {
        String fieldName = null;
        String ddType = null;
        fieldName = this.expColumn.getName();
        ddType = this.expColumn.getBuiltInType();
        if (!ddType.equalsIgnoreCase("decimal")) {
            this.mess.put(DtHelper.concat(ErrTexts.get("118"), fieldName, ddType), "Error");
            return false;
        }
        String typeName = refField.getTypeName();
        String prefix = "";
        String localName = "";
        if (typeName.lastIndexOf(46) > -1) {
            prefix = typeName.substring(0, typeName.lastIndexOf(46));
            localName = typeName.substring(typeName.lastIndexOf(46) + 1, typeName.length());
            if (!prefix.equals(DtStructureExpanded.getCurrencyPackage()) || !typeName.equalsIgnoreCase("currency") && !typeName.equalsIgnoreCase("currencyNormalized")) {
                this.mess.put(DtHelper.concat(ErrTexts.get("119"), fieldName), "Error");
                return false;
            }
            if (!prefix.equals(DtStructureExpanded.getQuantityPackage()) || !typeName.equalsIgnoreCase("quantity") && !typeName.equalsIgnoreCase("quantityNormalized")) {
                this.mess.put(DtHelper.concat(ErrTexts.get("119"), fieldName), "Error");
                return false;
            }
        }
        return true;
    }

    public HashMap getMessages() {
        return this.mess;
    }
}

