/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.designtime.DtDatabaseInfoExpanded;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtIndexChecker;
import com.sap.dictionary.designtime.DtIndexColumnExpanded;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtIndexField;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;

public class DtIndexExpanded {
    private String name = "";
    private String tableName = "";
    private String author = "";
    private String language = "";
    private String description = "";
    private String deploymentStatus = "";
    private String predefinedAction = "";
    private boolean isUnique = false;
    private ArrayList gColumns = new ArrayList();
    private ArrayList gDatabaseInfo = new ArrayList();
    private TreeMap sortedFields = new TreeMap();

    public DtIndexExpanded(DtDbIndex dtIndex) {
        this.name = dtIndex.getName();
        this.tableName = dtIndex.getParent().getName();
        this.predefinedAction = dtIndex.getPredefinedAction();
        this.isUnique = dtIndex.getUnique();
        DtIndexField[] dtIndexFields = dtIndex.getIndexFields();
        Object gIndexColumn = null;
        int i = 0;
        while (i <= dtIndexFields.length - 1) {
            this.sortedFields.put(new Integer(dtIndexFields[i].getPosition()), dtIndexFields[i]);
            ++i;
        }
        Set keySet = this.sortedFields.keySet();
        Iterator iter = keySet.iterator();
        DtIndexField nextField = null;
        int j = 0;
        while (iter.hasNext()) {
            nextField = (DtIndexField)this.sortedFields.get(iter.next());
            this.gColumns.add(j, new DtIndexColumnExpanded(nextField.getName(), false));
            ++j;
        }
        DtNoCreateCondition[] databases = dtIndex.getNoCreationOnDatabases();
        DtDatabaseInfoExpanded expDatabaseInfo = null;
        int i2 = 0;
        while (i2 < databases.length) {
            expDatabaseInfo = new DtDatabaseInfoExpanded(databases[i2].getDatabase().toString().toUpperCase(), databases[i2].getDeleteIfExisting());
            this.gDatabaseInfo.add(expDatabaseInfo);
            ++i2;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public String getPredefinedAction() {
        return this.predefinedAction;
    }

    public boolean getIsUnique() {
        return this.isUnique;
    }

    public ArrayList getColumns() {
        return this.gColumns;
    }

    public ArrayList getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        int i = 0;
        while (i < this.gColumns.size()) {
            columnNames.add(((DtIndexColumnExpanded)this.gColumns.get(i)).getName());
            ++i;
        }
        return columnNames;
    }

    public ArrayList getDatabaseInfo() {
        return this.gDatabaseInfo;
    }

    public boolean getDatabaseInfoExists() {
        return this.gDatabaseInfo.size() > 0;
    }

    public boolean indexIsOk(HashMap messages) {
        DtIndexChecker checker = new DtIndexChecker(this, messages);
        return checker.nameIsOk() & checker.noDuplicateFields() & checker.columnsExist();
    }

    public void writeToXmlFile(PrintWriter file, String offset0) {
        file.println(offset0 + "<index name=" + "\"" + this.name + "\"" + ">");
        String offset1 = offset0 + DtHelper.tabulate();
        file.println(offset1 + "<tabname>" + this.tableName + "</tabname>");
        file.println(offset1 + "<is-unique>" + this.isUnique + "</is-unique>");
        file.println(offset1 + "<columns>");
        int i = 0;
        while (i < this.gColumns.size()) {
            ((DtIndexColumnExpanded)this.gColumns.get(i)).writeToXmlFile(file, offset1 + DtHelper.tabulate());
            ++i;
        }
        file.println(offset1 + "</columns>");
        String offset2 = offset1 + DtHelper.tabulate();
        if (this.getDatabaseInfoExists()) {
            file.println(offset1 + "<database-exclusive-info>");
            int i2 = 0;
            while (i2 < this.gDatabaseInfo.size()) {
                file.println(offset2 + "<database-exclusive>");
                ((DtDatabaseInfoExpanded)this.gDatabaseInfo.get(i2)).writeToXmlFile(file, offset2);
                file.println(offset2 + "</database-exclusive>");
                ++i2;
            }
            file.println(offset1 + "</database-exclusive-info>");
        }
        file.println(offset0 + "</index>");
    }

    public XmlMap getXmlMap() {
        XmlMap index = new XmlMap();
        XmlMap columns = new XmlMap();
        XmlMap databaseInfo = new XmlMap();
        index.put("name", this.name);
        index.put("tabname", this.tableName);
        if (this.isUnique) {
            index.put("is-unique", "true");
        } else {
            index.put("is-unique", "false");
        }
        int i = 0;
        while (i < this.gColumns.size()) {
            columns.put("column" + (i == 0 ? "" : "" + i), ((DtIndexColumnExpanded)this.gColumns.get(i)).getXmlMap());
            ++i;
        }
        index.put("columns", columns);
        if (this.getDatabaseInfoExists()) {
            int i2 = 0;
            while (i2 < this.gDatabaseInfo.size()) {
                databaseInfo.put("database-exclusive" + (i2 == 0 ? "" : "" + i2), ((DtDatabaseInfoExpanded)this.gDatabaseInfo.get(i2)).getXmlMap());
                ++i2;
            }
            index.put("database-exclusive-info", databaseInfo);
        }
        return index;
    }

    public String toString() {
        ListIterator iter = null;
        String s = null;
        s = "  Indexname  " + this.name + "\n" + "  isUnique   " + this.isUnique + "\n";
        iter = ((AbstractList)this.gColumns).listIterator();
        while (iter.hasNext()) {
            s = s + (DtIndexColumnExpanded)iter.next();
        }
        iter = ((AbstractList)this.gDatabaseInfo).listIterator();
        s = s + "  Additional Database Info:" + "\n";
        while (iter.hasNext()) {
            s = s + (DtDatabaseInfoExpanded)iter.next();
        }
        return s + "\n";
    }
}

