/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtIndexColumnExpanded;
import com.sap.dictionary.designtime.DtIndexExpanded;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.sql.sqlparser.SQLKeywords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class DtIndexChecker {
    DtIndexExpanded expIndex = null;
    HashMap mess = new HashMap();
    String indexName = null;

    public DtIndexChecker() {
    }

    public DtIndexChecker(DtIndexExpanded expIndex, HashMap messages) {
        this.expIndex = expIndex;
        this.indexName = expIndex.getName();
        this.mess = messages;
    }

    public boolean nameIsOk() {
        String allowedCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        String allowedAtFirstPosition = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        HashMap<String, String> messages = new HashMap<String, String>();
        int ch = 32;
        int i = 0;
        while (i < this.indexName.length()) {
            ch = this.indexName.toUpperCase().charAt(i);
            if (allowedCharacters.indexOf(ch) == -1) {
                messages.put(ErrTexts.get("029"), "Error");
            }
            ++i;
        }
        ch = this.indexName.toUpperCase().charAt(0);
        if (allowedAtFirstPosition.indexOf(ch) == -1) {
            messages.put(ErrTexts.get("030"), "Error");
        }
        if (this.indexName.indexOf(ch = 95) == -1) {
            messages.put(ErrTexts.get("106"), "Error");
        }
        if (this.indexName.length() > 18) {
            messages.put(DtHelper.concat(ErrTexts.get("300"), this.indexName), "Error");
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean nameIsOk(String indexName) {
        this.indexName = indexName;
        return this.nameIsOk();
    }

    public boolean reservedWordIsUsed() {
        if (SQLKeywords.isKeyword((String)this.indexName)) {
            this.mess.put(DtHelper.concat(ErrTexts.get("114"), this.indexName), "Error");
            return false;
        }
        return true;
    }

    public boolean noDuplicateFields() {
        HashMap<String, String> messages = new HashMap<String, String>();
        ArrayList gIndexColumns = this.expIndex.getColumns();
        HashSet checkFields = new HashSet();
        String fieldName = null;
        int i = 0;
        while (i < checkFields.size()) {
            boolean notContained = checkFields.add(gIndexColumns.get(i));
            if (!notContained) {
                fieldName = ((DtIndexColumnExpanded)gIndexColumns.get(i)).getName();
                messages.put(DtHelper.concat(ErrTexts.get("301"), fieldName, this.indexName), "Error");
            }
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean columnsExist() {
        ArrayList gIndexColumns = this.expIndex.getColumns();
        if (gIndexColumns.size() <= 0) {
            this.mess.put(ErrTexts.get("302"), "Error");
            return false;
        }
        return true;
    }

    public boolean indexesAreDifferent(DtIndexExpanded other) {
        ArrayList cols1 = this.expIndex.getColumnNames();
        ArrayList cols2 = other.getColumnNames();
        int min = cols1.size();
        if (cols2.size() < cols1.size()) {
            min = cols2.size();
        }
        int i = 0;
        while (i < min) {
            if (!((String)cols1.get(i)).equalsIgnoreCase((String)cols2.get(i))) {
                return true;
            }
            ++i;
        }
        if (cols1.size() == cols2.size()) {
            this.mess.put(DtHelper.concat(ErrTexts.get("304"), this.expIndex.getName(), other.getName()), "Error");
        } else if (cols1.size() > cols2.size()) {
            this.mess.put(DtHelper.concat(ErrTexts.get("305"), this.expIndex.getName(), other.getName()), "Warning");
        } else if (cols1.size() < cols2.size()) {
            this.mess.put(DtHelper.concat(ErrTexts.get("305"), other.getName(), this.expIndex.getName()), "Warning");
        }
        return false;
    }

    public boolean indexAndPrimaryAreDifferent(ArrayList primaryKey) {
        ArrayList indexCols = this.expIndex.getColumnNames();
        if (indexCols.size() == primaryKey.size()) {
            int i = 0;
            while (i < indexCols.size()) {
                if (!((String)indexCols.get(i)).equalsIgnoreCase((String)primaryKey.get(i))) {
                    return true;
                }
                ++i;
            }
            this.mess.put(DtHelper.concat(ErrTexts.get("306"), this.expIndex.getName()), "Error");
            return false;
        }
        return true;
    }

    public HashMap getMessages() {
        return this.mess;
    }
}

